% Generated by roxygen2 (4.0.1): do not edit by hand
\name{makeMeasure}
\alias{Measure}
\alias{makeMeasure}
\title{Construct performance measure.}
\usage{
makeMeasure(id, minimize, properties = character(0L),
  allowed.pred.types = character(0L), fun, extra.args = list(),
  aggr = test.mean, best = NULL, worst = NULL)
}
\arguments{
\item{id}{[\code{character(1)}]\cr
Name of measure.}

\item{minimize}{[\code{logical(1)}]\cr
Should the measure be minimized?
Default is in \code{TRUE}.}

\item{properties}{[\code{character}]\cr
Set of measure properties. Some standard property names include:
\describe{
  \item{classif}{Is the measure applicable for classification?}
  \item{classif.multi}{Is the measure applicable for multi-class classification?}
  \item{regr}{Is the measure applicable for regression?}
  \item{surv}{Is the measure applicable for survival?}
  \item{costsens}{Is the measure applicable for cost-sensitve learning?}
}
Default is \code{character(0)}.}

\item{allowed.pred.types}{[\code{character}]\cr
Which prediction types are allowed for this measure?
Subset of \dQuote{response},\dQuote{prob}, \dQuote{se}.
Default is \code{character(0)}.}

\item{fun}{[\code{function(task, model, pred, extra.args)}]\cr
Calculates performance value.}

\item{extra.args}{[\code{list}]\cr
List of extra arguments which will always be passed to \code{fun}.
Default is empty list.}

\item{aggr}{[\code{\link{Aggregation}}]\cr
Aggregation funtion, which is used to aggregate the values measured
on test / training sets of the measure to a single value.
Default is \code{\link{test.mean}}.}

\item{best}{[\code{numeric(1)}]\cr
Best obtainable value for measure.
Default is -\code{Inf} or \code{Inf}, depending on \code{minimize}.}

\item{worst}{[\code{numeric(1)}]\cr
Worst obtainable value for measure.
Default is \code{Inf} or -\code{Inf}, depending on \code{minimize}.}
}
\value{
[\code{\link{Measure}}].
}
\description{
A measure object encapsulates a function to evaluate the performance of a prediction.
Information about already implemented measures can be obtained here: \code{\link{measures}}.

A learner is trained on a a training set d1, results in a model m, predicts another set d2
(which may be a different one or the training set), resulting in the prediction.
The performance measure can now be defined using all of the information of the original task,
the fitted model and the prediction.

Object slots:
\describe{
  \item{id [\code{character(1)}]}{See argument.}
  \item{minimize [\code{logical(1)}]}{See argument.}
  \item{properties [\code{character}]}{See argument.}
  \item{allowed.pred.types [\code{character}]}{See argument.}
  \item{req.pred [\code{logical(1)}]}{Is prediction object required in calculation?}
  \item{req.task [\code{logical(1)}]}{Is task object required in calculation?.}
  \item{req.model [\code{logical(1)}]}{Is model object required in calculation?}
  \item{fun [\code{function}]}{See argument.}
  \item{extra.args [\code{list}]}{See argument.}
  \item{aggr [\code{\link{Aggregation}}]}{See argument.}.
  \item{best [\code{numeric(1)}]}{See argument.}
  \item{worst [\code{numeric(1)}]}{See argument.}
}
}
\examples{
f = function(task, model, pred, extra.args)
  sum((pred$data$response - pred$data$truth)^2)
makeMeasure(id = "my.sse", minimize = TRUE, properties = c("regr", "response"), fun = f)
}
\seealso{
Other performance: \code{\link{G1}}, \code{\link{G2}},
  \code{\link{acc}}, \code{\link{auc}}, \code{\link{bac}},
  \code{\link{ber}}, \code{\link{cindex}},
  \code{\link{db}}, \code{\link{dunn}}, \code{\link{f1}},
  \code{\link{fdr}}, \code{\link{featperc}},
  \code{\link{fn}}, \code{\link{fnr}}, \code{\link{fp}},
  \code{\link{fpr}}, \code{\link{gmean}},
  \code{\link{gpr}}, \code{\link{mae}}, \code{\link{mcc}},
  \code{\link{mcp}}, \code{\link{meancosts}},
  \code{\link{measures}}, \code{\link{medae}},
  \code{\link{medse}}, \code{\link{mmce}},
  \code{\link{mse}}, \code{\link{multiclass.auc}},
  \code{\link{npv}}, \code{\link{ppv}}, \code{\link{rmse}},
  \code{\link{sae}}, \code{\link{silhouette}},
  \code{\link{sse}}, \code{\link{timeboth}},
  \code{\link{timepredict}}, \code{\link{timetrain}},
  \code{\link{tn}}, \code{\link{tnr}}, \code{\link{tp}},
  \code{\link{tpr}}; \code{\link{makeCostMeasure}};
  \code{\link{makeCustomResampledMeasure}};
  \code{\link{performance}}
}

