% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaggingWrapper.R
\name{makeBaggingWrapper}
\alias{makeBaggingWrapper}
\title{Fuse learner with the bagging technique.}
\usage{
makeBaggingWrapper(learner, bw.iters = 10L, bw.replace = TRUE, bw.size,
  bw.feats = 1)
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{bw.iters}{[\code{integer(1)}]\cr
Iterations = number of fitted models in bagging.
Default is 10.}

\item{bw.replace}{[\code{logical(1)}]\cr
Sample bags with replacement (bootstrapping)?
Default is TRUE.}

\item{bw.size}{[\code{numeric(1)}]\cr
Percentage size of sampled bags.
Default is 1 for bootstrapping and 0.632 for subsampling.}

\item{bw.feats}{[\code{numeric(1)}]\cr
Percentage size of randomly selected features in bags.
Default is 1.
At least one feature will always be selected.}
}
\value{
[\code{\link{Learner}}].
}
\description{
Fuses a learner with the bagging method
(i.e., similar to what a \code{randomForest} does).
Creates a learner object, which can be
used like any other learner object.
Models can easily be accessed via \code{\link{getLearnerModel}}.

Bagging is implemented as follows:
For each iteration a random data subset is sampled (with or without replacement)
and potentially the number of features is also restricted to
a random subset. Note that this is usually handled in a slightly different way
in the random forest where features are sampled at each tree split).

Prediction works as follows:
For classification we do majority voting to create a discrete label and
probabilities are predicted by considering the proportions of all predicted labels.
For regression the mean value and the standard deviations across predictions is computed.

Note that the passed base learner must always have \code{predict.type = 'response'},
while the BaggingWrapper can estimate probabilities and standard errors, so it can
be set, e.g., to \code{predict.type = 'prob'}. For this reason, when you call
\code{\link{setPredictType}}, the type is only set for the BaggingWrapper, not passed
down to the inner learner.
}
\seealso{
Other wrapper: \code{\link{makeConstantClassWrapper}},
  \code{\link{makeCostSensClassifWrapper}},
  \code{\link{makeCostSensRegrWrapper}},
  \code{\link{makeDownsampleWrapper}},
  \code{\link{makeFeatSelWrapper}},
  \code{\link{makeFilterWrapper}},
  \code{\link{makeImputeWrapper}},
  \code{\link{makeMulticlassWrapper}},
  \code{\link{makeMultilabelBinaryRelevanceWrapper}},
  \code{\link{makeMultilabelClassifierChainsWrapper}},
  \code{\link{makeMultilabelDBRWrapper}},
  \code{\link{makeMultilabelNestedStackingWrapper}},
  \code{\link{makeMultilabelStackingWrapper}},
  \code{\link{makeOverBaggingWrapper}},
  \code{\link{makePreprocWrapperCaret}},
  \code{\link{makePreprocWrapper}},
  \code{\link{makeRemoveConstantFeaturesWrapper}},
  \code{\link{makeSMOTEWrapper}},
  \code{\link{makeTuneWrapper}},
  \code{\link{makeUndersampleWrapper}},
  \code{\link{makeWeightedClassesWrapper}}
}
