% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterEnsemble.R
\name{makeFilterEnsemble}
\alias{makeFilterEnsemble}
\title{Create an ensemble feature filter.}
\usage{
makeFilterEnsemble(name, base.methods, desc, fun)
}
\arguments{
\item{name}{(\code{character(1)})\cr
Identifier for the filter.}

\item{base.methods}{the base filter methods which the ensemble method
will use.}

\item{desc}{(\code{character(1)})\cr
Short description of the filter.}

\item{fun}{(\code{function(task, nselect, ...})\cr
Function which takes a task and returns a named numeric vector of scores,
one score for each feature of \code{task}.
Higher scores mean higher importance of the feature.
At least \code{nselect} features must be calculated, the remaining may be
set to \code{NA} or omitted, and thus will not be selected.
the original order will be restored if necessary.}
}
\value{
Object of class \dQuote{FilterEnsemble}.
}
\description{
Creates and registers custom ensemble feature filters. Implemented ensemble filters
can be listed with \link{listFilterEnsembleMethods}. Additional
documentation for the \code{fun} parameter specific to each filter can
be found in the description.
}
\seealso{
Other filter: \code{\link{filterFeatures}},
  \code{\link{generateFilterValuesData}},
  \code{\link{getFilteredFeatures}},
  \code{\link{listFilterEnsembleMethods}},
  \code{\link{listFilterMethods}},
  \code{\link{makeFilterWrapper}},
  \code{\link{makeFilter}}, \code{\link{plotFilterValues}}
}
\concept{filter}
