% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StackedLearner.R
\name{makeStackedLearner}
\alias{makeStackedLearner}
\title{Create a stacked learner object.}
\usage{
makeStackedLearner(
  base.learners,
  super.learner = NULL,
  predict.type = NULL,
  method = "stack.nocv",
  use.feat = FALSE,
  resampling = NULL,
  parset = list()
)
}
\arguments{
\item{base.learners}{((list of) \link{Learner})\cr
A list of learners created with \code{makeLearner}.}

\item{super.learner}{(\link{Learner} | character(1))\cr
The super learner that makes the final prediction based on the base
learners. If you pass a string, the super learner will be created via
\code{makeLearner}. Not used for \code{method = 'average'}. Default is \code{NULL}.}

\item{predict.type}{(\code{character(1)})\cr
Sets the type of the final prediction for \code{method = 'average'}. For other
methods, the predict type should be set within \code{super.learner}. If the type
of the base learner prediction, which is set up within \code{base.learners}, is
\itemize{
\item \code{"prob"}\cr then \code{predict.type = 'prob'} will use the average of all
base learner predictions and \code{predict.type = 'response'} will use the
class with highest probability as final prediction.
\item \code{"response"}\cr then, for classification tasks with \code{predict.type =    'prob'}, the final prediction will be the relative frequency based on the
predicted base learner classes and classification tasks with \code{predict.type    = 'response'} will use majority vote of the base learner predictions to
determine the final prediction. For regression tasks, the final prediction
will be the average of the base learner predictions.
}}

\item{method}{(\code{character(1)})\cr
\dQuote{average} for averaging the predictions of the base learners,
\dQuote{stack.nocv} for building a super learner using the predictions of
the base learners,
\dQuote{stack.cv} for building a super learner using cross-validated
predictions of the base learners.
\dQuote{hill.climb} for averaging the predictions of the base learners,
with the weights learned from hill climbing algorithm and
\dQuote{compress} for compressing the model to mimic the predictions of a
collection of base learners while speeding up the predictions and reducing
the size of the model. Default is \dQuote{stack.nocv},}

\item{use.feat}{(\code{logical(1)})\cr
Whether the original features should also be passed to the super learner.
Not used for \code{method = 'average'}.
Default is \code{FALSE}.}

\item{resampling}{(\link{ResampleDesc})\cr
Resampling strategy for \code{method = 'stack.cv'}.
Currently only CV is allowed for resampling.
The default \code{NULL} uses 5-fold CV.}

\item{parset}{the parameters for \code{hill.climb} method, including
\itemize{
\item \code{replace}\cr Whether a base learner can be selected more than once.
\item \code{init}\cr Number of best models being included before the selection algorithm.
\item \code{bagprob}\cr The proportion of models being considered in one round of selection.
\item \code{bagtime}\cr The number of rounds of the bagging selection.
\item \code{metric}\cr The result evaluation metric function taking two parameters
\code{pred} and \code{true}, the smaller the score the better.
}

the parameters for \code{compress} method, including
\itemize{
\item k\cr the size multiplier of the generated data
\item prob\cr the probability to exchange values
\item s\cr the standard deviation of each numerical feature
}}
}
\description{
A stacked learner uses predictions of several base learners and
fits a super learner using these predictions as features in order to
predict the outcome. The following stacking methods are available:
\itemize{
\item \code{average}\cr Averaging of base learner predictions without weights.
\item \code{stack.nocv}\cr Fits the super learner, where in-sample predictions of
the base learners are used.
\item \code{stack.cv}\cr Fits the super learner, where the base learner predictions
are computed by cross-validated predictions (the resampling strategy can be
set via the \code{resampling} argument).
\item \code{hill.climb}\cr Select a subset of base learner predictions by hill
climbing algorithm.
\item \code{compress}\cr Train a neural network to compress the model from a
collection of base learners.
}
}
\examples{
# Classification
data(iris)
tsk = makeClassifTask(data = iris, target = "Species")
base = c("classif.rpart", "classif.lda", "classif.svm")
lrns = lapply(base, makeLearner)
lrns = lapply(lrns, setPredictType, "prob")
m = makeStackedLearner(base.learners = lrns,
  predict.type = "prob", method = "hill.climb")
tmp = train(m, tsk)
res = predict(tmp, tsk)

# Regression
data(BostonHousing, package = "mlbench")
tsk = makeRegrTask(data = BostonHousing, target = "medv")
base = c("regr.rpart", "regr.svm")
lrns = lapply(base, makeLearner)
m = makeStackedLearner(base.learners = lrns,
  predict.type = "response", method = "compress")
tmp = train(m, tsk)
res = predict(tmp, tsk)
}
