% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/generateLearningCurve.R
\name{generateLearningCurveData}
\alias{generateLearningCurveData}
\title{Generates a learning curve}
\usage{
generateLearningCurveData(learners, task, resampling = NULL,
  percs = seq(0.1, 1, by = 0.1), measures, stratify = FALSE,
  show.info = getMlrOption("show.info"))
}
\arguments{
\item{learners}{[(list of) \code{\link{Learner}}]\cr
Learning algorithms which should be compared.}

\item{task}{[\code{\link{Task}}]\cr
The task.}

\item{resampling}{[\code{\link{ResampleDesc}} | \code{\link{ResampleInstance}}]\cr
Resampling strategy to evaluate the performance measure.
If no strategy is given a default "Holdout" will be performed.}

\item{percs}{[\code{numeric}]\cr
Vector of percentages to be drawn from the training split.
These values represent the x-axis.
Internally \code{\link{makeDownsampleWrapper}} is used in combination with \code{\link{benchmark}}.
Thus for each percentage a different set of observations is drawn resulting in noisy performance measures as the quality of the sample can differ.}

\item{measures}{[(list of) \code{\link{Measure}}]\cr
Performance measures to generate learning curves for, representing the y-axis.}

\item{stratify}{[\code{logical(1)}]\cr
Only for classification:
Should the downsampled data be stratified according to the target classes?}

\item{show.info}{[\code{logical(1)}]\cr
Print verbose output on console?
Default is set via \code{\link{configureMlr}}.}
}
\value{
A [\code{data.frame}] of class \code{LearningCurveData}.
}
\description{
Observe how the performance changes with an increasing number of observations.
}
\examples{
r = generateLearningCurveData(list("classif.rpart", "classif.knn"),
task = sonar.task, percs = seq(0.2, 1, by = 0.2),
measures = list(tp, fp, tn, fn), resampling = makeResampleDesc(method = "Subsample", iters = 5),
show.info = FALSE)
plotLearningCurve(r)
}
\seealso{
Other generate_plot_data: \code{\link{generateFilterValuesData}};
  \code{\link{generateROCRCurvesData}};
  \code{\link{generateThreshVsPerfData}};
  \code{\link{getFilterValues}}

Other learning_curve: \code{\link{plotLearningCurveGGVIS}};
  \code{\link{plotLearningCurve}}
}

