% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertBMRToRankMatrix.R
\name{convertBMRToRankMatrix}
\alias{convertBMRToRankMatrix}
\title{Convert BenchmarkResult to a rank-matrix.}
\usage{
convertBMRToRankMatrix(bmr, measure = NULL, ties.method = "average",
  aggregation = "default")
}
\arguments{
\item{bmr}{[\code{\link{BenchmarkResult}}]\cr
Benchmark result.}

\item{measure}{[\code{\link{Measure}}]\cr
Performance measure.
Default is the default measure for the task, see here \code{\link{getDefaultMeasure}}.}

\item{ties.method}{[\code{character(1)}]\cr
see \code{\link{rank}} for details.}

\item{aggregation}{[\code{character(1)}] \cr
\dQuote{mean} or \dQuote{default}. See \code{\link{getBMRAggrPerformances}}
for details on \dQuote{default}.}
}
\value{
[\code{matrix}]
Matrix, with measure ranks as entries. \cr  
The matrix has one row for each \code{learner},
and one column for each \code{task}.
}
\description{
Computes a matrix of all the ranks of different algorithms
over different datasets (tasks). Ranks are computed from aggregated 
measures.
}
\examples{
# see benchmark
# convertBMRToRankMatrix(res, acc)

}
\seealso{
Other benchmark: \code{\link{BenchmarkResult}},
  \code{\link{benchmark}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{friedmanTestBMR}},
  \code{\link{generateBenchmarkSummaryData}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{generateRankMatrixAsBarData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFeatSelResults}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBenchmarkResult}},
  \code{\link{plotBenchmarkSummary}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotRankMatrixAsBar}}
}

