% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateCalibration.R
\name{plotCalibration}
\alias{plotCalibration}
\title{Plot calibration data using ggplot2.}
\usage{
plotCalibration(obj, smooth = FALSE, reference = TRUE, rag = TRUE)
}
\arguments{
\item{obj}{[\code{CalibrationData}]\cr
Result of \code{\link{generateCalibrationData}}}

\item{smooth}{[\code{logical(1)}]\cr
Whether to use a loess smoother.
Default is \code{FALSE}.}

\item{reference}{[\code{logical(1)}]\cr
Whether to plot a reference line showing perfect calibration.
Default is \code{TRUE}.}

\item{rag}{[\code{logical(1)}]\cr
Whether to include a rag plot which shows a rug plot on the top which pertains to
positive cases and on the bottom which pertains to negative cases.
Default is \code{TRUE}.}
}
\value{
ggplot2 plot object.
}
\description{
Plots calibration data from \code{\link{generateCalibrationData}}.
}
\examples{
\dontrun{
lrns = list(makeLearner("classif.rpart", predict.type = "prob"),
            makeLearner("classif.nnet", predict.type = "prob"))
fit = lapply(lrns, train, task = iris.task)
pred = lapply(fit, predict, task = iris.task)
names(pred) = c("rpart", "nnet")
out = generateCalibrationData(pred, groups = 3)
plotCalibration(out)

fit = lapply(lrns, train, task = sonar.task)
pred = lapply(fit, predict, task = sonar.task)
names(pred) = c("rpart", "lda")
out = generateCalibrationData(pred)
plotCalibration(out)
}
}
\seealso{
Other calibration: \code{\link{generateCalibrationData}}

Other plot: \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotFilterValues}},
  \code{\link{plotLearningCurveGGVIS}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialPredictionGGVIS}},
  \code{\link{plotPartialPrediction}},
  \code{\link{plotROCCurves}},
  \code{\link{plotROCRCurvesGGVIS}},
  \code{\link{plotROCRCurves}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}
}

