% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateROCRCurves.R
\name{plotROCRCurves}
\alias{plotROCRCurves}
\title{Plots results from generateROCRCurvesData using ggplot2.}
\usage{
plotROCRCurves(obj, diagonal = FALSE, xlab, ylab, title = "")
}
\arguments{
\item{obj}{[\code{ROCRCurvesData}]\cr
Result of \code{\link{generateROCRCurvesData}}.}

\item{diagonal}{[\code{logical(1)}]\cr
Whether to plot a dashed diagonal line.
Default is false.}

\item{xlab}{[\code{character(1)}]\cr
Label for x-axis.
Default is \code{meas1}.}

\item{ylab}{[\code{character(1)}]\cr
Label for y-axis.
Default is \code{meas2}.}

\item{title}{[\code{character(1)}]\cr
Title for plot.
Default is an empty string.}
}
\value{
ggplot2 plot object.
}
\description{
Visualize how binary classification performs across different measures.
}
\seealso{
Other plot: \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotFilterValues}},
  \code{\link{plotLearningCurveGGVIS}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialPredictionGGVIS}},
  \code{\link{plotPartialPrediction}},
  \code{\link{plotROCCurves}},
  \code{\link{plotROCRCurvesGGVIS}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}

Other predict: \code{\link{asROCRPrediction}},
  \code{\link{generateROCRCurvesData}},
  \code{\link{getPredictionProbabilities}},
  \code{\link{getPredictionResponse}},
  \code{\link{plotROCRCurvesGGVIS}},
  \code{\link{plotViperCharts}},
  \code{\link{predict.WrappedModel}},
  \code{\link{setPredictThreshold}},
  \code{\link{setPredictType}}

Other roc: \code{\link{asROCRPrediction}},
  \code{\link{generateROCRCurvesData}},
  \code{\link{plotROCRCurvesGGVIS}},
  \code{\link{plotViperCharts}}
}

