% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_sqlite_backend.R
\name{as_sqlite_backend}
\alias{as_sqlite_backend}
\title{Convert to use a SQLite Backend}
\usage{
as_sqlite_backend(data, path = NULL, ...)
}
\arguments{
\item{data}{(\code{data.frame()} | \link[mlr3:DataBackend]{mlr3::DataBackend} | \link[mlr3:Task]{mlr3::Task})\cr
See description.}

\item{path}{(\code{NULL} | \code{character(1)})\cr
Path for the SQLite data base. Defaults to a file in the temporary directory of the R session, see \code{\link[=tempfile]{tempfile()}}.}

\item{...}{(\code{any})\cr
Additional arguments, currently ignored.}
}
\value{
\link{DataBackendDplyr}.
}
\description{
Converts to a \link{DataBackendDplyr} using a \CRANpkg{RSQLite} data base, depending on the input type:
\itemize{
\item \code{data.frame}: Converts to a \link{DataBackendDplyr}.
\item \code{[mlr3::DataBackend]}: Creates a new \link{DataBackendDplyr} using the data of the provided \link[mlr3:DataBackend]{mlr3::DataBackend}.
\item \code{[mlr3::Task]}: Replaces the \link{DataBackend} in slot \code{$task} with a new backend. Only active columns and
rows are considered.
}
}
