% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataBackendDplyr.R
\name{DataBackendDplyr}
\alias{DataBackendDplyr}
\title{DataBackend for dplyr/dbplyr}
\description{
A \link[mlr3:DataBackend]{mlr3::DataBackend} using \code{\link[dplyr:tbl]{dplyr::tbl()}} from packages \CRANpkg{dplyr}/\CRANpkg{dbplyr}.
This includes \code{\link[tibble:tibble]{tibbles}} and abstract database connections interfaced by \CRANpkg{dbplyr}.
The latter allows \link[mlr3:Task]{mlr3::Task}s to interface an out-of-memory database.
}
\examples{
if (mlr3misc::require_namespaces(c("tibble", "RSQLite", "dbplyr"), quietly = TRUE)) {
  # Backend using a in-memory tibble
  data = tibble::as_tibble(iris)
  data$Sepal.Length[1:30] = NA
  data$row_id = 1:150
  b = DataBackendDplyr$new(data, primary_key = "row_id")

  # Object supports all accessors of DataBackend
  print(b)
  b$nrow
  b$ncol
  b$colnames
  b$data(rows = 100:101, cols = "Species")
  b$distinct(b$rownames, "Species")

  # Classification task using this backend
  task = mlr3::TaskClassif$new(id = "iris_tibble", backend = b, target = "Species")
  print(task)
  head(task)

  # Create a temporary SQLite database
  con = DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  dplyr::copy_to(con, data)
  tbl = dplyr::tbl(con, "data")

  # Define a backend on a subset of the database: do not use column "Sepal.Width"
  tbl = dplyr::select_at(tbl, setdiff(colnames(tbl), "Sepal.Width"))
  tbl = dplyr::filter(tbl, row_id \%in\% 1:120) # Use only first 120 rows
  b = DataBackendDplyr$new(tbl, primary_key = "row_id")
  print(b)

  # Query disinct values
  b$distinct(b$rownames, "Species")

  # Query number of missing values
  b$missings(b$rownames, b$colnames)

  # Note that SQLite does not support factors, column Species has been converted to character
  lapply(b$head(), class)

  # Cleanup
  rm(tbl)
  DBI::dbDisconnect(con)
}
}
\section{Super class}{
\code{\link[mlr3:DataBackend]{mlr3::DataBackend}} -> \code{DataBackendDplyr}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{levels}}{(named \code{list()})\cr
List (named with column names) of factor levels as \code{character()}.
Used to auto-convert character columns to factor variables.}

\item{\code{connector}}{(\verb{function()})\cr
Function which is called to re-connect in case the connection became invalid.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{rownames}}{(\code{integer()})\cr
Returns vector of all distinct row identifiers, i.e. the contents of the primary key column.}

\item{\code{colnames}}{(\code{character()})\cr
Returns vector of all column names, including the primary key column.}

\item{\code{nrow}}{(\code{integer(1)})\cr
Number of rows (observations).}

\item{\code{ncol}}{(\code{integer(1)})\cr
Number of columns (variables), including the primary key column.}

\item{\code{valid}}{(\code{logical(1)})\cr
Returns \code{NA} if the data does not inherits from \code{"tbl_sql"} (i.e., it is not a real SQL data base).
Returns the result of \code{\link[DBI:dbIsValid]{DBI::dbIsValid()}} otherwise.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataBackendDplyr-new}{\code{DataBackendDplyr$new()}}
\item \href{#method-DataBackendDplyr-finalize}{\code{DataBackendDplyr$finalize()}}
\item \href{#method-DataBackendDplyr-data}{\code{DataBackendDplyr$data()}}
\item \href{#method-DataBackendDplyr-head}{\code{DataBackendDplyr$head()}}
\item \href{#method-DataBackendDplyr-distinct}{\code{DataBackendDplyr$distinct()}}
\item \href{#method-DataBackendDplyr-missings}{\code{DataBackendDplyr$missings()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="DataBackend" data-id="format"><a href='../../mlr3/html/DataBackend.html#method-DataBackend-format'><code>mlr3::DataBackend$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="DataBackend" data-id="print"><a href='../../mlr3/html/DataBackend.html#method-DataBackend-print'><code>mlr3::DataBackend$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackendDplyr-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackendDplyr-new}{}}}
\subsection{Method \code{new()}}{
Creates a backend for a \code{\link[dplyr:tbl]{dplyr::tbl()}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendDplyr$new(
  data,
  primary_key,
  strings_as_factors = TRUE,
  connector = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{(\code{\link[dplyr:tbl]{dplyr::tbl()}})\cr
The data object.

Instead of calling the constructor yourself, you can call \code{\link[mlr3:as_data_backend]{mlr3::as_data_backend()}}
on a \code{\link[dplyr:tbl]{dplyr::tbl()}}.
Note that only objects of class \code{"tbl_lazy"} will be converted to a \link{DataBackendDplyr}
(this includes all connectors from \CRANpkg{dbplyr}).
Local \code{"tbl"} objects such as \code{\link[tibble:tibble]{tibbles}} will converted to a
\link[mlr3:DataBackendDataTable]{DataBackendDataTable}.}

\item{\code{primary_key}}{(\code{character(1)})\cr
Name of the primary key column.}

\item{\code{strings_as_factors}}{(\code{logical(1)} || \code{character()})\cr
Either a character vector of column names to convert to factors, or a single logical flag:
if \code{FALSE}, no column will be converted, if \code{TRUE} all string columns (except the primary key).
For conversion, the backend is queried for distinct values of the respective columns
on construction and their levels are stored in \verb{$levels}.}

\item{\code{connector}}{(function()\verb{)\\cr If not }NULL`, a function which re-connects to the database in case the connection has become invalid.
Database connections can become invalid due to timeouts or if the backend is serialized
to the file system and then de-serialized again.
This round trip is often performed for parallelization, e.g. to send the objects to remote workers.
\code{\link[DBI:dbIsValid]{DBI::dbIsValid()}} is called to validate the connection.
The function must return just the connection, not a \code{\link[dplyr:tbl]{dplyr::tbl()}} object!
Note that this this function is serialized together with the backend, including
possible sensitive information such as login credentials.
These can be retrieved from the stored \link[mlr3:DataBackend]{mlr3::DataBackend}/\link[mlr3:Task]{mlr3::Task}.
To protect your credentials, it is recommended to use the \CRANpkg{secret} package.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackendDplyr-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackendDplyr-finalize}{}}}
\subsection{Method \code{finalize()}}{
Finalizer which disconnects from the database.
This is called during garbage collection of the instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendDplyr$finalize()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{logical(1)}, the return value of \code{\link[DBI:dbDisconnect]{DBI::dbDisconnect()}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackendDplyr-data"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackendDplyr-data}{}}}
\subsection{Method \code{data()}}{
Returns a slice of the data.
Calls \code{\link[dplyr:filter]{dplyr::filter()}} and \code{\link[dplyr:select]{dplyr::select()}} on the table and converts it to a \code{\link[data.table:data.table]{data.table::data.table()}}.

The rows must be addressed as vector of primary key values, columns must be referred to via column names.
Queries for rows with no matching row id and queries for columns with no matching
column name are silently ignored.
Rows are guaranteed to be returned in the same order as \code{rows}, columns may be returned in an arbitrary order.
Duplicated row ids result in duplicated rows, duplicated column names lead to an exception.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendDplyr$data(rows, cols, data_format = "data.table")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices.}

\item{\code{cols}}{\code{character()}\cr
Column names.}

\item{\code{data_format}}{(\code{character(1)})\cr
Desired data format, e.g. \code{"data.table"} or \code{"Matrix"}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackendDplyr-head"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackendDplyr-head}{}}}
\subsection{Method \code{head()}}{
Retrieve the first \code{n} rows.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendDplyr$head(n = 6L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(\code{integer(1)})\cr
Number of rows.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} of the first \code{n} rows.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackendDplyr-distinct"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackendDplyr-distinct}{}}}
\subsection{Method \code{distinct()}}{
Returns a named list of vectors of distinct values for each column
specified. If \code{na_rm} is \code{TRUE}, missing values are removed from the
returned vectors of distinct values. Non-existing rows and columns are
silently ignored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendDplyr$distinct(rows, cols, na_rm = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices.}

\item{\code{cols}}{\code{character()}\cr
Column names.}

\item{\code{na_rm}}{\code{logical(1)}\cr
Whether to remove NAs or not.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Named \code{list()} of distinct values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackendDplyr-missings"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackendDplyr-missings}{}}}
\subsection{Method \code{missings()}}{
Returns the number of missing values per column in the specified slice
of data. Non-existing rows and columns are silently ignored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackendDplyr$missings(rows, cols)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices.}

\item{\code{cols}}{\code{character()}\cr
Column names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Total of missing values per column (named \code{numeric()}).
}
}
}
