% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelectorExhaustiveSearch.R
\name{mlr_fselectors_exhaustive_search}
\alias{mlr_fselectors_exhaustive_search}
\alias{FSelectorExhaustiveSearch}
\title{Feature Selection with Exhaustive Search}
\description{
Feature Selection using the Exhaustive Search Algorithm.
Exhaustive Search generates all possible feature sets.
}
\details{
The feature selection terminates itself when all feature sets are evaluated.
It is not necessary to set a termination criterion.
}
\section{Dictionary}{

This \link{FSelector} can be instantiated with the associated sugar function \code{\link[=fs]{fs()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{fs("exhaustive_search")
}\if{html}{\out{</div>}}
}

\section{Control Parameters}{

\describe{
\item{\code{max_features}}{\code{integer(1)}\cr
Maximum number of features.
By default, number of features in \link[mlr3:Task]{mlr3::Task}.}
}
}

\examples{
# Feature Selection
\donttest{

# retrieve task and load learner
task = tsk("penguins")
learner = lrn("classif.rpart")

# run feature selection on the Palmer Penguins data set
instance = fselect(
  method = "exhaustive_search",
  task = task,
  learner = learner,
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  term_evals = 10
)

# best performing feature set
instance$result

# all evaluated feature sets
as.data.table(instance$archive)

# subset the task and fit the final model
task$select(instance$result_feature_set)
learner$train(task)
}
}
\seealso{
Other FSelector: 
\code{\link{mlr_fselectors_design_points}},
\code{\link{mlr_fselectors_genetic_search}},
\code{\link{mlr_fselectors_random_search}},
\code{\link{mlr_fselectors_rfecv}},
\code{\link{mlr_fselectors_rfe}},
\code{\link{mlr_fselectors_sequential}},
\code{\link{mlr_fselectors_shadow_variable_search}},
\code{\link{mlr_fselectors}}
}
\concept{FSelector}
\section{Super class}{
\code{\link[mlr3fselect:FSelector]{mlr3fselect::FSelector}} -> \code{FSelectorExhaustiveSearch}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FSelectorExhaustiveSearch-new}{\code{FSelectorExhaustiveSearch$new()}}
\item \href{#method-FSelectorExhaustiveSearch-clone}{\code{FSelectorExhaustiveSearch$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="format"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-format'><code>mlr3fselect::FSelector$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="help"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-help'><code>mlr3fselect::FSelector$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="optimize"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-optimize'><code>mlr3fselect::FSelector$optimize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="print"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-print'><code>mlr3fselect::FSelector$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorExhaustiveSearch-new"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorExhaustiveSearch-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorExhaustiveSearch$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorExhaustiveSearch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorExhaustiveSearch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorExhaustiveSearch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
