% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_callbacks.R
\name{mlr3fselect.one_se_rule}
\alias{mlr3fselect.one_se_rule}
\title{One Standard Error Rule Callback}
\source{
Kuhn, Max, Johnson, Kjell (2013).
\dQuote{Applied Predictive Modeling.}
In chapter Over-Fitting and Model Tuning, 61--92.
Springer New York, New York, NY.
ISBN 978-1-4614-6849-3.
}
\description{
Selects the smallest feature set within one standard error of the best as the result.
If there are multiple feature sets with the same performance and number of features, the first one is selected.
}
\examples{
clbk("mlr3fselect.one_se_rule")

# Run feature selection on the pima data set with the callback
instance = fselect(
  fselector = fs("random_search"),
  task = tsk("pima"),
  learner = lrn("classif.rpart"),
  resampling = rsmp ("cv", folds = 3),
  measures = msr("classif.ce"),
  term_evals = 10,
  callbacks = clbk("mlr3fselect.one_se_rule"))
# Smallest feature set within one standard error of the best
instance$result
}
