% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_fselect.R
\name{ensemble_fselect}
\alias{ensemble_fselect}
\title{Ensemble Feature Selection}
\source{
Saeys, Yvan, Abeel, Thomas, Van De Peer, Yves (2008).
\dQuote{Robust feature selection using ensemble feature selection techniques.}
\emph{Machine Learning and Knowledge Discovery in Databases}, \bold{5212 LNAI}, 313--325.
\doi{10.1007/978-3-540-87481-2_21}.

Abeel, Thomas, Helleputte, Thibault, Van de Peer, Yves, Dupont, Pierre, Saeys, Yvan (2010).
\dQuote{Robust biomarker identification for cancer diagnosis with ensemble feature selection methods.}
\emph{Bioinformatics}, \bold{26}, 392--398.
ISSN 1367-4803, \doi{10.1093/BIOINFORMATICS/BTP630}.

Pes, Barbara (2020).
\dQuote{Ensemble feature selection for high-dimensional data: a stability analysis across multiple domains.}
\emph{Neural Computing and Applications}, \bold{32}(10), 5951--5973.
ISSN 14333058, \doi{10.1007/s00521-019-04082-3}.
}
\usage{
ensemble_fselect(
  fselector,
  task,
  learners,
  init_resampling,
  inner_resampling,
  measure,
  terminator,
  callbacks = NULL,
  store_benchmark_result = TRUE,
  store_models = TRUE
)
}
\arguments{
\item{fselector}{(\link{FSelector})\cr
Optimization algorithm.}

\item{task}{(\link[mlr3:Task]{mlr3::Task})\cr
Task to operate on.}

\item{learners}{(list of \link[mlr3:Learner]{mlr3::Learner})\cr
The learners to be used for feature selection.}

\item{init_resampling}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
The initial resampling strategy of the data, from which each train set
will be passed on to the learners.
Can only be \link[mlr3:mlr_resamplings_subsampling]{mlr3::ResamplingSubsampling} or \link[mlr3:mlr_resamplings_bootstrap]{mlr3::ResamplingBootstrap}.}

\item{inner_resampling}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
The inner resampling strategy used by the \link{FSelector}.}

\item{measure}{(\link[mlr3:Measure]{mlr3::Measure})\cr
Measure to optimize. If \code{NULL}, default measure is used.}

\item{terminator}{(\link[bbotk:Terminator]{bbotk::Terminator})\cr
Stop criterion of the feature selection.}

\item{callbacks}{(list of lists of \link{CallbackBatchFSelect})\cr
Callbacks to be used for each learner.
The lists must have the same length as the number of learners.}

\item{store_benchmark_result}{(\code{logical(1)})\cr
Whether to store the benchmark result in \link{EnsembleFSResult} or not.}

\item{store_models}{(\code{logical(1)})\cr
Whether to store models in \link{auto_fselector} or not.}
}
\value{
an \link{EnsembleFSResult} object.
}
\description{
Ensemble feature selection using multiple learners.
The ensemble feature selection method is designed to identify the most informative features from a given dataset by leveraging multiple machine learning models and resampling techniques.
Returns an \link{EnsembleFSResult}.
}
\details{
The method begins by applying an initial resampling technique specified by the user, to create \strong{multiple subsamples} from the original dataset.
This resampling process helps in generating diverse subsets of data for robust feature selection.

For each subsample generated in the previous step, the method performs \strong{wrapped-based feature selection} (\link{auto_fselector}) using each provided learner, the given inner resampling method, performance measure and optimization algorithm.
This process generates the best feature subset for each combination of subsample and learner.
Results are stored in an \link{EnsembleFSResult}.
}
\examples{
\donttest{
  efsr = ensemble_fselect(
    fselector = fs("random_search"),
    task = tsk("sonar"),
    learners = lrns(c("classif.rpart", "classif.featureless")),
    init_resampling = rsmp("subsampling", repeats = 2),
    inner_resampling = rsmp("cv", folds = 3),
    measure = msr("classif.ce"),
    terminator = trm("evals", n_evals = 10)
  )
  efsr
}
}
