% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classif_bacc.R
\name{bacc}
\alias{bacc}
\title{Balanced Accuracy}
\usage{
bacc(truth, response, sample_weights = NULL, ...)
}
\arguments{
\item{truth}{:: \code{factor()}\cr
True (observed) labels.
Must have the same levels and length as \code{response}.}

\item{response}{:: \code{factor()}\cr
Predicted response labels.
Must have the same levels and length as \code{truth}.}

\item{sample_weights}{:: \code{numeric()}\cr
Non-negative sample weights.
Must have the same levels and length as \code{truth}.
Defaults to equal sample weights.}

\item{...}{:: \code{any}\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Computes the weighted balanced accuracy, suitable for imbalanced data sets.
It is defined analogously to the definition in \href{https://scikit-learn.org/}{sklearn}.

First, the sample weights \eqn{w} are normalized per class:
\deqn{
 \hat{w}_i = \frac{w_i}{\sum_j 1(y_j = y_i) w_i}.
}{
 w_hat[i] = w[i] / sum((t == t[i]) * w[i]).
}
The balanced accuracy is calculated as
\deqn{
 \frac{1}{\sum_i \hat{w}_i} \sum_i 1(r_i = t_i) \hat{w}_i.
}{
 1 / sum(w_hat) * sum((r == t) * w_hat).
}
}
\section{Meta Information}{

\itemize{
\item Type: \code{"classif"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
lvls = c("a", "b", "c")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
response = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
bacc(truth, response)
}
\references{
\cite{brodersen_2010}

\cite{guyon_2015}
}
\seealso{
Other Classification Measures: \code{\link{acc}},
  \code{\link{ce}}, \code{\link{logloss}}
}
\concept{Classification Measures}
\concept{classification_measure}
