% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_bbrier.R
\name{bbrier}
\alias{bbrier}
\title{Binary Brier Score}
\usage{
bbrier(truth, prob, positive, sample_weights = NULL, ...)
}
\arguments{
\item{truth}{(\code{factor()})\cr
True (observed) labels.
Must have the exactly same two levels and the same length as \code{response}.}

\item{prob}{(\code{numeric()})\cr
Predicted probability for positive class.
Must have exactly same length as \code{truth}.}

\item{positive}{(\verb{character(1))}\cr
Name of the positive class.}

\item{sample_weights}{(\code{numeric()})\cr
Vector of non-negative and finite sample weights.
Must have the same length as \code{truth}.
The vector gets automatically normalized to sum to one.
Defaults to equal sample weights.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Brier score for binary classification problems defined as \deqn{
   \frac{1}{n} \sum_{i=1}^n w_i (I_i - p_i)^2.
}{
   weighted.mean(((t == positive) - p)^2, w).
}
\if{latex}{
\eqn{w_i} are the sample weights,
\eqn{I_{i}}{I_i} is 1 if observation \eqn{i} belongs to the positive class, and 0 otherwise.
}

Note that this (more common) definition of the Brier score is equivalent to the
original definition of the multi-class Brier score (see \code{\link[=mbrier]{mbrier()}}) divided by 2.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"binary"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{TRUE}
\item Required prediction: \code{prob}
}
}

\examples{
set.seed(1)
lvls = c("a", "b")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
prob = runif(10)
bbrier(truth, prob, positive = "a")
}
\references{
\url{https://en.wikipedia.org/wiki/Brier_score}

Brier GW (1950).
\dQuote{Verification of forecasts expressed in terms of probability.}
\emph{Monthly Weather Review}, \bold{78}(1), 1--3.
\doi{10.1175/1520-0493(1950)078<0001:vofeit>2.0.co;2}.
}
\seealso{
Other Binary Classification Measures: 
\code{\link{auc}()},
\code{\link{dor}()},
\code{\link{fbeta}()},
\code{\link{fdr}()},
\code{\link{fnr}()},
\code{\link{fn}()},
\code{\link{fomr}()},
\code{\link{fpr}()},
\code{\link{fp}()},
\code{\link{mcc}()},
\code{\link{npv}()},
\code{\link{ppv}()},
\code{\link{prauc}()},
\code{\link{tnr}()},
\code{\link{tn}()},
\code{\link{tpr}()},
\code{\link{tp}()}
}
\concept{Binary Classification Measures}
\concept{binary_classification_measure}
