% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_mode.R
\name{compute_mode}
\alias{compute_mode}
\title{Compute The Mode}
\usage{
compute_mode(x, ties_method = "random", na_rm = TRUE)
}
\arguments{
\item{x}{:: \code{vector()}.}

\item{ties_method}{:: \code{character(1)}\cr
Handling of ties. One of "first", "last" or "random" to return the first tied value,
the last tied value, or a randomly selected tied value, respectively.}

\item{na_rm}{:: \code{logical(1)}\cr
If \code{TRUE}, remove missing values prior to computing the mode.}
}
\value{
(\code{vector(1)}): mode value.
}
\description{
Computes the mode (most frequent value) of an atomic vector.
}
\examples{
compute_mode(c(1, 1, 1, 2, 2, 2, 3))
compute_mode(c(1, 1, 1, 2, 2, 2, 3), ties_method = "last")
compute_mode(c(1, 1, 1, 2, 2, 2, 3), ties_method = "random")
}
