% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest.R
\name{unnest}
\alias{unnest}
\title{Unnest List Data Table Columns}
\usage{
unnest(x, cols, prefix = NULL)
}
\arguments{
\item{x}{:: \code{\link[data.table:data.table]{data.table::data.table()}}\cr
\code{\link[data.table:data.table]{data.table::data.table()}} with columns to unnest.}

\item{cols}{:: \code{character()}\cr
Column names of list columns to operate on.}

\item{prefix}{:: \code{character(1)}\cr
String to prefix the new column names with.}
}
\value{
(\code{\link[data.table:data.table]{data.table::data.table()}}).
}
\description{
Transforms each element of a list columns into its own column, possibly by reference.
}
\examples{
x = data.table::data.table(
  id = 1:2,
  value = list(list(a = 1, b = 2), list(a = 2, b = 2))
)
print(x)
unnest(x, "value")
}
