% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_bib.R
\name{format_bib}
\alias{format_bib}
\alias{cite_bib}
\title{Format Bibentries in Roxygen}
\usage{
format_bib(..., bibentries = NULL, envir = parent.frame())

cite_bib(..., bibentries = NULL, envir = parent.frame())
}
\arguments{
\item{...}{(\code{character()})\cr
One or more names of bibentries.}

\item{bibentries}{(named \code{list()})\cr
Named list of bibentries.}

\item{envir}{(\code{environment})\cr
Environment to lookup \code{bibentries} if not provided.}
}
\value{
(\code{character(1)}).
}
\description{
Operates on a named list of \code{\link[=bibentry]{bibentry()}} entries and formats them nicely for
documentation with \CRANpkg{roxygen2}.
\itemize{
\item \code{format_bib()} is intended to be called in the \verb{@references} section and
prints the complete entry using \code{\link[=toRd]{toRd()}}.
\item \code{cite_bib()} returns the family name of the first author (if available, falling back
to the complete author name if not applicable) and the year in format
\code{"[LastName] (YYYY)"}.
}
}
\examples{
bibentries = list(checkmate = citation("checkmate"), R = citation())
format_bib("checkmate")
format_bib("R")
cite_bib("checkmate")
cite_bib("checkmate", "R")
}
