% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_oml_data_sets.R, R/list_oml_evaluations.R,
%   R/list_oml_flows.R, R/list_oml_measures.R, R/list_oml_runs.R,
%   R/list_oml_setups.R, R/list_oml_tasks.R
\name{list_oml}
\alias{list_oml}
\alias{list_oml_data_sets}
\alias{list_oml_evaluations}
\alias{list_oml_flows}
\alias{list_oml_measures}
\alias{list_oml_runs}
\alias{list_oml_setups}
\alias{list_oml_tasks}
\title{List Data from OpenML}
\usage{
list_oml_data_sets(
  data_id = NULL,
  data_name = NULL,
  number_instances = NULL,
  number_features = NULL,
  number_classes = NULL,
  number_missing_values = NULL,
  tag = NULL,
  limit = getOption("mlr3oml.limit", 5000L),
  ...
)

list_oml_evaluations(
  run_id = NULL,
  task_id = NULL,
  measures = NULL,
  tag = NULL,
  limit = getOption("mlr3oml.limit", 5000L),
  ...
)

list_oml_flows(
  uploader = NULL,
  tag = NULL,
  limit = getOption("mlr3oml.limit", 5000L),
  ...
)

list_oml_measures()

list_oml_runs(
  run_id = NULL,
  task_id = NULL,
  tag = NULL,
  limit = getOption("mlr3oml.limit", 5000L),
  ...
)

list_oml_setups(
  flow_id = NULL,
  setup_id = NULL,
  tag = NULL,
  limit = getOption("mlr3oml.limit", 5000L),
  ...
)

list_oml_tasks(
  task_id = NULL,
  data_id = NULL,
  number_instances = NULL,
  number_features = NULL,
  number_classes = NULL,
  number_missing_values = NULL,
  tag = NULL,
  limit = getOption("mlr3oml.limit", 5000L),
  ...
)
}
\arguments{
\item{data_id}{(\code{integer()})\cr
Vector of data ids to restrict to.}

\item{data_name}{(\code{character(1)})\cr
Filter for name of data set.}

\item{number_instances}{(\code{integer()})\cr
Filter for number of instances.}

\item{number_features}{(\code{integer()})\cr
Filter for number of features.}

\item{number_classes}{(\code{integer()})\cr
Filter for number of labels of the target (only classification tasks).}

\item{number_missing_values}{(\code{integer()})\cr
Filter for number of missing values.}

\item{tag}{(\code{character()})\cr
Filter for tags. You can provide multiple tags as character vector.}

\item{limit}{(\code{integer()})\cr
Limit the results to \code{limit} records.
Default is the value of option \code{"mlr3oml.limit"}, defaulting to 5000.}

\item{...}{(any)\cr
Additional (unsupported) filters, as named arguments.}

\item{run_id}{(\code{integer()})\cr
Vector of run ids to restrict to.}

\item{task_id}{(\code{integer()})\cr
Vector of task ids to restrict to.}

\item{measures}{(\code{character()})\cr
Vector of evaluation measures to restrict to.}

\item{uploader}{(\code{integer(1)})\cr
Filter for uploader.}

\item{flow_id}{(\code{integer(1)})\cr
Filter for flow id.}

\item{setup_id}{(\code{integer()})\cr
Vector of setup ids to restrict to.}
}
\value{
(\code{data.table()}) of results, or a null data.table if no data set matches the filter criteria.
}
\description{
This function allows to query data sets, tasks, flows, setups, runs, and evaluation measures
from \url{https://openml.org/d} using some simple filter criteria.
}
\details{
Filter values are usually provided as single atomic values (typically integer or character).
Provide a numeric vector of length 2 (\code{c(l, u)}) to find matches in the range \eqn{[l, u]}.

Note that only a subset of filters is exposed here.
For a more feature-complete package, see \CRANpkg{OpenML}.
Alternatively, you can pass additional filters via \code{...} using the names of the official API,
c.f. \url{https://www.openml.org/api_docs}.
}
\examples{
\donttest{
### query data sets
# search for titanic data set
data_sets = list_oml_data_sets(data_name = "titanic")
print(data_sets)

# search for a reduced version
data_sets = list_oml_data_sets(
  data_name = "titanic",
  number_instances = c(2200, 2300),
  number_features = 4
)
print(data_sets)

### search tasks for this data set
tasks = list_oml_tasks(data_id = data_sets$data_id)
print(tasks)


# query runs, group by number of runs per task_id
runs = list_oml_runs(task_id = tasks$task_id)
runs[, .N, by = task_id]
}
}
\references{
Casalicchio G, Bossek J, Lang M, Kirchhoff D, Kerschke P, Hofner B, Seibold H, Vanschoren J, Bischl B (2017).
\dQuote{OpenML: An R Package to Connect to the Machine Learning Platform OpenML.}
\emph{Computational Statistics}, 1--15.
\doi{10.1007/s00180-017-0742-2}.

Vanschoren J, van Rijn JN, Bischl B, Torgo L (2014).
\dQuote{OpenML.}
\emph{ACM SIGKDD Explorations Newsletter}, \bold{15}(2), 49--60.
\doi{10.1145/2641190.2641198}.
}
