% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_grid_oml.R
\name{benchmark_grid_oml}
\alias{benchmark_grid_oml}
\title{Helper function to create a benchmark design}
\usage{
benchmark_grid_oml(tasks, learners, resamplings)
}
\arguments{
\item{tasks}{(\code{list()} or \code{Task}) A list of \link[mlr3:Task]{mlr3::Task}s.}

\item{learners}{(\code{list()} or \code{Learner}) A list of \link[mlr3:Learner]{mlr3::Learner}s.}

\item{resamplings}{(\code{list()} or \code{Resampling}) A list of \link[mlr3:Resampling]{mlr3::Resampling}s that are instantiated on the given tasks.}
}
\value{
(\code{\link[=data.table]{data.table()}})
}
\description{
\link{OMLTask}s contain tasks as well as resamplings. In order to create
a benchmark design from a list of tasks and corresponding instantiated resamplings, this
function can be used.
}
\examples{
\donttest{
library("mlr3")
collection = OMLCollection$new(258)
otasks = collection$tasks[1:2, ][["task"]]
tasks = as_tasks(otasks)
resamplings = as_resamplings(otasks)
learners = lrns(c("classif.rpart", "classif.featureless"))
design = benchmark_grid_oml(tasks, learners, resamplings)
print(design)
bmr = benchmark(design)
}
}
