% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpOVR.R
\name{mlr_pipeops_ovrsplit}
\alias{mlr_pipeops_ovrsplit}
\alias{PipeOpOVRSplit}
\title{Split a Classification Task into Binary Classification Tasks}
\format{
\code{\link[R6:R6Class]{R6Class}} inheriting from \code{\link{PipeOp}}.
}
\description{
Splits a \link[mlr3:TaskClassif]{classification Task} into several binary \link[mlr3:TaskClassif]{classification Tasks} to perform "One vs. Rest" classification. This works in combination
with \code{\link{PipeOpOVRUnite}}.

For each target level a new binary \link[mlr3:TaskClassif]{classification Task} is constructed with
the respective target level being the positive class and all other target levels being the
new negative class \code{"rest"}.

This \code{\link{PipeOp}} creates a \code{\link{Multiplicity}}, which means that subsequent \code{\link{PipeOp}}s are executed
multiple times, once for each created \link[mlr3:TaskClassif]{binary Task}, until a \code{\link{PipeOpOVRUnite}}
is reached.

Note that \code{\link{Multiplicity}} is currently an experimental features and the implementation or UI
may change.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpOVRSplit$new(id = "ovrsplit", param_vals = list())
}\if{html}{\out{</div>}}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of the resulting object, default \code{"ovrsplit"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

\code{\link{PipeOpOVRSplit}} has one input channel named \code{"input"} taking a \code{\link[mlr3:TaskClassif]{TaskClassif}}
both during training and prediction.

\code{\link{PipeOpOVRSplit}} has one output channel named \code{"output"} returning a \code{\link{Multiplicity}} of
\code{\link[mlr3:TaskClassif]{TaskClassif}}s both during training and prediction, i.e., the newly
constructed binary \link[mlr3:TaskClassif]{classification Tasks}.
}

\section{State}{

The \verb{$state} contains the original target levels of the \code{\link[mlr3:TaskClassif]{TaskClassif}} supplied
during training.
}

\section{Parameters}{

\code{\link{PipeOpOVRSplit}} has no parameters.
}

\section{Internals}{

The original target levels stored in the \verb{$state} are also used during prediction when creating the new
binary \link[mlr3:TaskClassif]{classification Tasks}.

The names of the element of the output \code{\link{Multiplicity}} are given by the levels of the target.

If a target level \code{"rest"} is present in the input \code{\link[mlr3:TaskClassif]{TaskClassif}}, the
negative class will be labeled as \verb{"rest." (using as many }"."` postfixes needed to yield a
valid label).

Should be used in combination with \code{\link{PipeOpOVRUnite}}.
}

\section{Fields}{

Only fields inherited from \code{\link{PipeOp}}.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOp}}.
}

\examples{
\dontshow{ if (requireNamespace("rpart")) \{ }
library(mlr3)
task = tsk("iris")
po = po("ovrsplit")
po$train(list(task))
po$predict(list(task))
\dontshow{ \} }
}
\seealso{
https://mlr-org.com/pipeops.html

Other PipeOps: 
\code{\link{PipeOp}},
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{mlr_pipeops}},
\code{\link{mlr_pipeops_adas}},
\code{\link{mlr_pipeops_blsmote}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_rowapply}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_smotenc}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}}

Other Multiplicity PipeOps: 
\code{\link{Multiplicity}()},
\code{\link{PipeOpEnsemble}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_replicate}}

Other Experimental Features: 
\code{\link{Multiplicity}()},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_replicate}}
}
\concept{Experimental Features}
\concept{Multiplicity PipeOps}
\concept{PipeOps}
