% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingRepeatedSpCVEnv.R
\name{ResamplingRepeatedSpCVEnv}
\alias{ResamplingRepeatedSpCVEnv}
\title{Repeated Environmental Block Cross Validation Resampling}
\description{
Environmental Block Cross Validation. This strategy uses k-means
clustering to specify blocks of similar environmental conditions. Only
numeric features can be used. The \code{features} used for building blocks can
be specified in the \code{param_set}. By default, all numeric features are used.
}
\examples{
if (mlr3misc::require_namespaces(c("sf", "blockCV"), quietly = TRUE)) {
  library(mlr3)
  task = tsk("ecuador")

  # Instantiate Resampling
  rrcv = rsmp("repeated_spcv_env", folds = 4, repeats = 2)
  rrcv$instantiate(task)

  # Individual sets:
  rrcv$train_set(1)
  rrcv$test_set(1)
  intersect(rrcv$train_set(1), rrcv$test_set(1))

  # Internal storage:
  rrcv$instance
}
}
\references{
Valavi R, Elith J, Lahoz-Monfort JJ, Guillera-Arroita G (2018).
\dQuote{blockCV: an R package for generating spatially or environmentally separated folds for k-fold cross-validation of species distribution models.}
\emph{bioRxiv}.
\doi{10.1101/357798}.
}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingRepeatedSpCVEnv}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{iters}}{\code{integer(1)}\cr
Returns the number of resampling iterations, depending on the
values stored in the \code{param_set}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ResamplingRepeatedSpCVEnv$new()}}
\item \href{#method-folds}{\code{ResamplingRepeatedSpCVEnv$folds()}}
\item \href{#method-repeats}{\code{ResamplingRepeatedSpCVEnv$repeats()}}
\item \href{#method-instantiate}{\code{ResamplingRepeatedSpCVEnv$instantiate()}}
\item \href{#method-clone}{\code{ResamplingRepeatedSpCVEnv$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format">}\href{../../mlr3/html/Resampling.html#method-format}{\code{mlr3::Resampling$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help">}\href{../../mlr3/html/Resampling.html#method-help}{\code{mlr3::Resampling$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print">}\href{../../mlr3/html/Resampling.html#method-print}{\code{mlr3::Resampling$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set">}\href{../../mlr3/html/Resampling.html#method-test_set}{\code{mlr3::Resampling$test_set()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set">}\href{../../mlr3/html/Resampling.html#method-train_set}{\code{mlr3::Resampling$train_set()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an "coordinate-based" repeated resampling instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVEnv$new(id = "repeated_spcv_env")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character(1)}\cr
Identifier for the resampling strategy.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-folds"></a>}}
\if{latex}{\out{\hypertarget{method-folds}{}}}
\subsection{Method \code{folds()}}{
Translates iteration numbers to fold number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVEnv$folds(iters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{\code{integer()}\cr
Iteration number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-repeats"></a>}}
\if{latex}{\out{\hypertarget{method-repeats}{}}}
\subsection{Method \code{repeats()}}{
Translates iteration numbers to repetition number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVEnv$repeats(iters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{\code{integer()}\cr
Iteration number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-instantiate"></a>}}
\if{latex}{\out{\hypertarget{method-instantiate}{}}}
\subsection{Method \code{instantiate()}}{
Materializes fixed training and test splits for a given task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVEnv$instantiate(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{\link{Task}\cr
A task to instantiate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSpCVEnv$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
