% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.ResamplingSpCVBlock}
\alias{autoplot.ResamplingSpCVBlock}
\alias{autoplot.ResamplingRepeatedSpCVBlock}
\alias{plot.ResamplingSpCVBlock}
\alias{plot.ResamplingRepeatedSpCVBlock}
\title{Visualization Functions for SpCV Block Methods.}
\usage{
\method{autoplot}{ResamplingSpCVBlock}(
  object,
  task,
  fold_id = NULL,
  plot_as_grid = TRUE,
  train_color = "#0072B5",
  test_color = "#E18727",
  show_blocks = FALSE,
  show_labels = FALSE,
  sample_fold_n = NULL,
  label_size = 2,
  ...
)

\method{autoplot}{ResamplingRepeatedSpCVBlock}(
  object,
  task,
  fold_id = NULL,
  repeats_id = 1,
  plot_as_grid = TRUE,
  train_color = "#0072B5",
  test_color = "#E18727",
  show_blocks = FALSE,
  show_labels = FALSE,
  sample_fold_n = NULL,
  label_size = 2,
  ...
)

\method{plot}{ResamplingSpCVBlock}(x, ...)

\method{plot}{ResamplingRepeatedSpCVBlock}(x, ...)
}
\arguments{
\item{object}{\verb{[Resampling]}\cr
mlr3 spatial resampling object of class \link{ResamplingSpCVBlock} or
\link{ResamplingRepeatedSpCVBlock}.}

\item{task}{\verb{[TaskClassifST]/[TaskRegrST]}\cr
mlr3 task object.}

\item{fold_id}{\verb{[numeric]}\cr
Fold IDs to plot.}

\item{plot_as_grid}{\verb{[logical(1)]}\cr
Should a gridded plot using via \CRANpkg{patchwork} be created? If \code{FALSE}
a list with of \CRANpkg{ggplot2} objects is returned.
Only applies if a numeric vector is passed to argument \code{fold_id}.}

\item{train_color}{\verb{[character(1)]}\cr
The color to use for the training set observations.}

\item{test_color}{\verb{[character(1)]}\cr
The color to use for the test set observations.}

\item{show_blocks}{\verb{[logical(1)]}\cr
Whether to show an overlay of the spatial blocks polygons.}

\item{show_labels}{\verb{[logical(1)]}\cr
Whether to show an overlay of the spatial block IDs.}

\item{sample_fold_n}{\verb{[integer]}\cr
Number of points in a random sample stratified over partitions.
This argument aims to keep file sizes of resulting plots reasonable and
reduce overplotting in dense datasets.}

\item{label_size}{\verb{[numeric(1)]}\cr
Label size of block labels. Only applies for \code{show_labels = TRUE}.}

\item{...}{Passed to \code{geom_sf()}. Helpful for adjusting point sizes and
shapes.}

\item{repeats_id}{\verb{[numeric]}\cr
Repetition ID to plot.}

\item{x}{\verb{[Resampling]}\cr
mlr3 spatial resampling object. One of class \link{ResamplingSpCVBuffer},
\link{ResamplingSpCVBlock}, \link{ResamplingSpCVCoords}, \link{ResamplingSpCVEnv}.}
}
\value{
\code{\link[=ggplot]{ggplot()}} or list of ggplot2 objects.
}
\description{
Generic S3 \code{plot()} and \code{autoplot()} (ggplot2) methods to
visualize mlr3 spatiotemporal resampling objects.
}
\details{
By default a plot is returned; if \code{fold_id} is set, a gridded plot is
created. If \code{plot_as_grid = FALSE}, a list of plot objects is returned.
This can be used to align the plots individually.

When no single fold is selected, the \code{\link[ggsci:scale_ucscgb]{ggsci::scale_color_ucscgb()}} palette
is used to display all partitions.
If you want to change the colors, call \verb{<plot> + <color-palette>()}.
}
\examples{
\donttest{
if (mlr3misc::require_namespaces(c("sf", "blockCV"), quietly = TRUE)) {
  library(mlr3)
  library(mlr3spatiotempcv)
  task = tsk("ecuador")
  resampling = rsmp("spcv_block", range = 1000L)
  resampling$instantiate(task)

  ## list of ggplot2 resamplings
  plot_list = autoplot(resampling, task,
    crs = 4326,
    fold_id = c(1, 2), plot_as_grid = FALSE)

  ## Visualize all partitions
  autoplot(resampling, task) +
    ggplot2::scale_x_continuous(breaks = seq(-79.085, -79.055, 0.01))

  ## Visualize the train/test split of a single fold
  autoplot(resampling, task, fold_id = 1) +
    ggplot2::scale_x_continuous(breaks = seq(-79.085, -79.055, 0.01))

  ## Visualize train/test splits of multiple folds
  autoplot(resampling, task,
    fold_id = c(1, 2),
    show_blocks = TRUE) *
    ggplot2::scale_x_continuous(breaks = seq(-79.085, -79.055, 0.01))
}
}
}
\seealso{
\itemize{
\item mlr3book chapter on \href{https://mlr3book.mlr-org.com/chapters/chapter13/beyond_regression_and_classification.html#spatiotemp-cv}{"Spatiotemporal Visualization"}
\item \code{\link[=autoplot.ResamplingSpCVBuffer]{autoplot.ResamplingSpCVBuffer()}}
\item \code{\link[=autoplot.ResamplingSpCVCoords]{autoplot.ResamplingSpCVCoords()}}
\item \code{\link[=autoplot.ResamplingSpCVEnv]{autoplot.ResamplingSpCVEnv()}}
\item \code{\link[=autoplot.ResamplingSpCVDisc]{autoplot.ResamplingSpCVDisc()}}
\item \code{\link[=autoplot.ResamplingSpCVTiles]{autoplot.ResamplingSpCVTiles()}}
\item \code{\link[=autoplot.ResamplingCV]{autoplot.ResamplingCV()}}
\item \code{\link[=autoplot.ResamplingSptCVCstf]{autoplot.ResamplingSptCVCstf()}}
}
}
