% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TorchLoss.R
\name{TorchLoss}
\alias{TorchLoss}
\title{Torch Loss}
\description{
This wraps a \code{torch::nn_loss} and annotates it with metadata, most importantly a \code{\link[paradox:ParamSet]{ParamSet}}.
The loss function is created for the given parameter values by calling the \verb{$generate()} method.

This class is usually used to configure the loss function of a torch learner, e.g.
when construcing a learner or in a \code{\link{ModelDescriptor}}.

For a list of available losses, see \code{\link{mlr3torch_losses}}.
Items from this dictionary can be retrieved using \code{\link[=t_loss]{t_loss()}}.
}
\section{Parameters}{

Defined by the constructor argument \code{param_set}.
If no parameter set is provided during construction, the parameter set is constructed by creating a parameter
for each argument of the wrapped loss function, where the parametes are then of type \code{ParamUty}.
}

\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a new torch loss
torch_loss = TorchLoss$new(torch_loss = nn_mse_loss, task_types = "regr")
torch_loss
# the parameters are inferred
torch_loss$param_set

# Retrieve a loss from the dictionary:
torch_loss = t_loss("mse", reduction = "mean")
# is the same as
torch_loss
torch_loss$param_set
torch_loss$label
torch_loss$task_types
torch_loss$id

# Create the loss function
loss_fn = torch_loss$generate()
loss_fn
# Is the same as
nn_mse_loss(reduction = "mean")

# open the help page of the wrapped loss function
# torch_loss$help()

# Use in a learner
learner = lrn("regr.mlp", loss = t_loss("mse"))
# The parameters of the loss are added to the learner's parameter set
learner$param_set
\dontshow{\}) # examplesIf}
}
\seealso{
Other Torch Descriptor: 
\code{\link{TorchCallback}},
\code{\link{TorchDescriptor}},
\code{\link{TorchOptimizer}},
\code{\link{as_torch_callbacks}()},
\code{\link{as_torch_loss}()},
\code{\link{as_torch_optimizer}()},
\code{\link{mlr3torch_losses}},
\code{\link{mlr3torch_optimizers}},
\code{\link{t_clbk}()},
\code{\link{t_loss}()},
\code{\link{t_opt}()}
}
\concept{Torch Descriptor}
\section{Super class}{
\code{\link[mlr3torch:TorchDescriptor]{mlr3torch::TorchDescriptor}} -> \code{TorchLoss}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{task_types}}{(\code{character()})\cr
The task types this loss supports.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TorchLoss-new}{\code{TorchLoss$new()}}
\item \href{#method-TorchLoss-print}{\code{TorchLoss$print()}}
\item \href{#method-TorchLoss-generate}{\code{TorchLoss$generate()}}
\item \href{#method-TorchLoss-clone}{\code{TorchLoss$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="TorchDescriptor" data-id="help"><a href='../../mlr3torch/html/TorchDescriptor.html#method-TorchDescriptor-help'><code>mlr3torch::TorchDescriptor$help()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TorchLoss-new"></a>}}
\if{latex}{\out{\hypertarget{method-TorchLoss-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TorchLoss$new(
  torch_loss,
  task_types = NULL,
  param_set = NULL,
  id = NULL,
  label = NULL,
  packages = NULL,
  man = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{torch_loss}}{(\code{nn_loss} or \code{function})\cr
The loss module or function that generates the loss module.
Can have arguments \code{task} that will be provided when the loss is instantiated.}

\item{\code{task_types}}{(\code{character()})\cr
The task types supported by this loss.}

\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}} or \code{NULL})\cr
The parameter set. If \code{NULL} (default) it is inferred from \code{torch_loss}.}

\item{\code{id}}{(\code{character(1)})\cr
The id for of the new object.}

\item{\code{label}}{(\code{character(1)})\cr
Label for the new instance.}

\item{\code{packages}}{(\code{character()})\cr
The R packages this object depends on.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TorchLoss-print"></a>}}
\if{latex}{\out{\hypertarget{method-TorchLoss-print}{}}}
\subsection{Method \code{print()}}{
Prints the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TorchLoss$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{any}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TorchLoss-generate"></a>}}
\if{latex}{\out{\hypertarget{method-TorchLoss-generate}{}}}
\subsection{Method \code{generate()}}{
Instantiates the loss function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TorchLoss$generate(task = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\code{Task})\cr
The task. Must be provided if the loss function requires a task.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{torch_loss}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TorchLoss-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TorchLoss-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TorchLoss$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
