% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTorchOptimizer.R
\name{mlr_pipeops_torch_optimizer}
\alias{mlr_pipeops_torch_optimizer}
\alias{PipeOpTorchOptimizer}
\title{Optimizer Configuration}
\description{
Configures the optimizer of a deep learning model.
}
\section{Parameters}{

The parameters are defined dynamically from the optimizer that is set during construction.
}

\section{Input and Output Channels}{

There is one input channel \code{"input"} and one output channel \code{"output"}.
During \emph{training}, the channels are of class \code{\link{ModelDescriptor}}.
During \emph{prediction}, the channels are of class \code{\link[mlr3:Task]{Task}}.
}

\section{State}{

The state is the value calculated by the public method \code{shapes_out()}.
}

\section{Internals}{

During training, the optimizer is cloned and added to the \code{\link{ModelDescriptor}}.
Note that the parameter set of the stored \code{\link{TorchOptimizer}} is reference-identical to the parameter set of the
pipeop itself.
}

\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
po_opt = po("torch_optimizer", "sgd", lr = 0.01)
po_opt$param_set
mdin = po("torch_ingress_num")$train(list(tsk("iris")))
mdin[[1L]]$optimizer
mdout = po_opt$train(mdin)
mdout[[1L]]$optimizer
\dontshow{\}) # examplesIf}
}
\seealso{
Other PipeOp: 
\code{\link{mlr_pipeops_module}},
\code{\link{mlr_pipeops_torch_callbacks}}

Other Model Configuration: 
\code{\link{ModelDescriptor}()},
\code{\link{mlr_pipeops_torch_callbacks}},
\code{\link{mlr_pipeops_torch_loss}},
\code{\link{model_descriptor_union}()}
}
\concept{Model Configuration}
\concept{PipeOp}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpTorchOptimizer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpTorchOptimizer-new}{\code{PipeOpTorchOptimizer$new()}}
\item \href{#method-PipeOpTorchOptimizer-clone}{\code{PipeOpTorchOptimizer$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTorchOptimizer-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTorchOptimizer-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTorchOptimizer$new(
  optimizer = t_opt("adam"),
  id = "torch_optimizer",
  param_vals = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{optimizer}}{(\code{\link{TorchOptimizer}} or \code{character(1)} or \code{torch_optimizer_generator})\cr
The optimizer (or something convertible via \code{\link[=as_torch_optimizer]{as_torch_optimizer()}}).}

\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpTorchOptimizer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpTorchOptimizer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpTorchOptimizer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
