% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_nested.R
\name{tune_nested}
\alias{tune_nested}
\title{Function for Nested Resampling}
\usage{
tune_nested(
  method,
  task,
  learner,
  inner_resampling,
  outer_resampling,
  measure = NULL,
  term_evals = NULL,
  term_time = NULL,
  search_space = NULL,
  ...
)
}
\arguments{
\item{method}{(\code{character(1)})\cr
Key to retrieve tuner from \link{mlr_tuners} dictionary.}

\item{task}{(\link[mlr3:Task]{mlr3::Task})\cr
Task to operate on.}

\item{learner}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Learner to tune.}

\item{inner_resampling}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
Resampling used for the inner loop.}

\item{outer_resampling}{\link[mlr3:Resampling]{mlr3::Resampling})\cr
Resampling used for the outer loop.}

\item{measure}{(\link[mlr3:Measure]{mlr3::Measure})\cr
Measure to optimize. If \code{NULL}, default measure is used.}

\item{term_evals}{(\code{integer(1)})\cr
Number of allowed evaluations.}

\item{term_time}{(\code{integer(1)})\cr
Maximum allowed time in seconds.}

\item{search_space}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Hyperparameter search space. If \code{NULL} (default), the search space is
constructed from the \link{TuneToken} of the learner's parameter set
(learner$param_set).}

\item{...}{(named \code{list()})\cr
Named arguments to be set as parameters of the tuner.}
}
\value{
\link[mlr3:ResampleResult]{mlr3::ResampleResult}
}
\description{
Function to conduct nested resampling.
}
\examples{
# Nested resampling on Palmer Penguins data set
rr = tune_nested(
  method = "random_search",
  task = tsk("penguins"),
  learner = lrn("classif.rpart", cp = to_tune(1e-04, 1e-1, logscale = TRUE)),
  inner_resampling = rsmp ("holdout"),
  outer_resampling = rsmp("cv", folds = 2),
  measure = msr("classif.ce"),
  term_evals = 2,
  batch_size = 2)

# Performance scores estimated on the outer resampling
rr$score()

# Unbiased performance of the final model trained on the full data set
rr$aggregate()
}
