% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{tune}
\alias{tune}
\title{Function for Tuning}
\usage{
tune(
  method,
  task,
  learner,
  resampling,
  measure,
  term_evals = NULL,
  term_time = NULL,
  search_space = NULL,
  ...
)
}
\arguments{
\item{method}{(\code{character(1)})\cr
Key to retrieve tuner from \link{mlr_tuners} dictionary.}

\item{task}{(\link[mlr3:Task]{mlr3::Task})\cr
Task to operate on.}

\item{learner}{(\link[mlr3:Learner]{mlr3::Learner}).}

\item{resampling}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
Uninstantiated resamplings are instantiated during construction
so that all configurations are evaluated on the same data splits.}

\item{measure}{(\link[mlr3:Measure]{mlr3::Measure})\cr
Measure to optimize.}

\item{term_evals}{(\code{integer(1)})\cr
Number of allowed evaluations.}

\item{term_time}{(\code{integer(1)})\cr
Maximum allowed time in seconds.}

\item{search_space}{(\link[paradox:ParamSet]{paradox::ParamSet}).}

\item{...}{(named \code{list()})\cr
Named arguments to be set as parameters of the tuner.}
}
\value{
\code{TuningInstanceSingleCrit}
}
\description{
Function to tune a \link[mlr3:Learner]{mlr3::Learner}.
}
\examples{
learner = lrn("classif.rpart")
learner$param_set$values$minsplit = to_tune(1, 10)

instance = tune(
  method = "random_search", 
  task = tsk("pima"), 
  learner = learner, 
  resampling = rsmp ("holdout"), 
  measure = msr("classif.ce"), 
  term_evals = 50, 
  batch_size = 10) 

# Apply hyperparameter values to learner
learner$param_set$values = instance$result_learner_param_vals
}
