% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClassifRpart.R, R/LearnerRegrRpart.R
\name{autoplot.LearnerClassifRpart}
\alias{autoplot.LearnerClassifRpart}
\alias{autoplot.LearnerRegrRpart}
\title{Plot for LearnerClassifRpart / LearnerRegrRpart}
\usage{
\method{autoplot}{LearnerClassifRpart}(object, ...)

\method{autoplot}{LearnerRegrRpart}(object, ...)
}
\arguments{
\item{object}{(\link[mlr3:mlr_learners_classif.rpart]{mlr3::LearnerClassifRpart} | \link[mlr3:mlr_learners_regr.rpart]{mlr3::LearnerRegrRpart}).}

\item{...}{(\code{any}):
Additional arguments, passed down to \code{\link[ggparty:autoplot.party]{ggparty::autoplot.party()}}.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Visualize trees for \link[mlr3:mlr_learners_classif.rpart]{mlr3::mlr_learners_classif.rpart} and
\link[mlr3:mlr_learners_regr.rpart]{mlr3::mlr_learners_regr.rpart} using the package \CRANpkg{ggparty}.

Contrary to \CRANpkg{ggparty}, boxplots are shown in the terminal nodes for
regression trees.

Note that learner-specific plots are experimental and subject to change.
}
\section{Theme}{

The \code{\link[=theme_mlr3]{theme_mlr3()}} and viridis color maps are applied by default to all
\code{autoplot()} methods. To change this behavior set
\code{options(mlr3.theme = FALSE)}.
}

\examples{
library(mlr3)
library(mlr3viz)

# classification
task = tsk("iris")
learner = lrn("classif.rpart", keep_model = TRUE)
learner$train(task)
autoplot(learner)

# regression
task = tsk("mtcars")
learner = lrn("regr.rpart", keep_model = TRUE)
learner$train(task)
autoplot(learner)
}
