% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClassifCVGlmnet.R,
%   R/LearnerClassifGlmnet.R, R/LearnerRegrCVGlmnet.R, R/LearnerRegrGlmnet.R
\name{autoplot.LearnerClassifCVGlmnet}
\alias{autoplot.LearnerClassifCVGlmnet}
\alias{autoplot.LearnerClassifGlmnet}
\alias{autoplot.LearnerRegrCVGlmnet}
\alias{autoplot.LearnerRegrGlmnet}
\title{Plots for GLMNet Learners}
\usage{
\method{autoplot}{LearnerClassifCVGlmnet}(object, theme = theme_minimal(), ...)

\method{autoplot}{LearnerClassifGlmnet}(object, theme = theme_minimal(), ...)

\method{autoplot}{LearnerRegrCVGlmnet}(object, theme = theme_minimal(), ...)

\method{autoplot}{LearnerRegrGlmnet}(object, theme = theme_minimal(), ...)
}
\arguments{
\item{object}{(\link[mlr3learners:mlr_learners_classif.glmnet]{mlr3learners::LearnerClassifGlmnet} | \link[mlr3learners:mlr_learners_regr.glmnet]{mlr3learners::LearnerRegrGlmnet} | \link[mlr3learners:mlr_learners_regr.cv_glmnet]{mlr3learners::LearnerRegrCVGlmnet} | \link[mlr3learners:mlr_learners_regr.cv_glmnet]{mlr3learners::LearnerRegrCVGlmnet}).}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{...}{(ignored).}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for GLMNet learners using the package \CRANpkg{ggfortify}.
}
\examples{
\dontrun{
library(mlr3)
library(mlr3viz)
library(mlr3learners)

# classification
task = tsk("sonar")
learner = lrn("classif.glmnet")
learner$train(task)
autoplot(learner)

# regression
task = tsk("mtcars")
learner = lrn("regr.glmnet")
learner$train(task)
autoplot(learner)
}
}
\references{
Tang Y, Horikoshi M, Li W (2016).
\dQuote{ggfortify: Unified Interface to Visualize Statistical Result of Popular R Packages.}
\emph{The R Journal}, \bold{8}(2), 474--485.
\doi{10.32614/RJ-2016-060}.
}
