% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{covrTraceCPOs}
\alias{covrTraceCPOs}
\title{Add 'covr' coverage to CPOs}
\usage{
covrTraceCPOs(env = parent.env(parent.frame()), force = FALSE)
}
\arguments{
\item{env}{[environment]\cr
The environment to search for \code{\link{CPO}}s. Default is \code{parent.env(parent.frame())},
which is the package namespace if called from \code{.onLoad}.}

\item{force}{[logical(1)]\cr
Trace \code{\link{CPO}} functions even when \code{R_COVR} is not \dQuote{true}.
Default is \code{FALSE}.}
}
\value{
[invisible(NULL)].
}
\description{
Use this if you want to check code coverage of \code{\link{CPO}}s using
\code{covr}. The functions inside \code{\link{CPO}}s is
originally not accessible to \code{covr}, so \code{covrTraceCPOs} needs to be called in
the \code{.onAttach} function. Note that putting it in \code{.onLoad} will \bold{not} work.

Currently, for this to work, the mb706 fork of \code{covr} needs to be used. To install it,
call

\code{devtools::install_github("mb706/covr")}

To use it on Travis CI, add the line \code{- mb706/covr} under the \code{r_github_packages:}
category.

This function comes at no runtime penalty: If the \code{R_COVR} environment variable is not
set to \dQuote{true}, then it only has an effect if \code{force} is \code{TRUE}.
}
