% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09-opal_functions.R
\name{opal_project_create}
\alias{opal_project_create}
\title{Create a project in an Opal environment}
\usage{
opal_project_create(opal, project, tag = NULL)
}
\arguments{
\item{opal}{Opal login attributes.}

\item{project}{A character string to name the project in Opal.}

\item{tag}{A character string to provide a tag for the Opal project.}
}
\value{
A project in an Opal environment. If the project already exists, it
will remain as it is, and no new project is created.
The user must have adequate credentials to interact with their Opal
environment.
}
\description{
Creates an empty project in an Opal environment. This is a wrapper function
for \code{\link[opalr:opal.project_create]{opalr::opal.project_create()}}.
}
\details{
Opal is the OBiBa application for data management, and Opal environments can
be integrated with RStudio environments using the package \code{opalr}.
The user must have adequate credentials to interact with a specific Opal
environment. Some function errors produced may be associated with the
handler or Opal read/write permissions.
}
\examples{
\dontrun{

library(opalr)
opal <-
 opal.login('administrator','password',
   url ='https://opal-demo.obiba.org/')

tempdir <- basename(tempdir())
try(opal_project_create(opal, tempdir))

}

}
\seealso{
Please see \href{https://opaldoc.obiba.org/}{Opal documentation} for
complete documentation.
}
