% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prctilemlx.R
\name{prctilemlx}
\alias{prctilemlx}
\title{Percentiles of the empiricial distribution of longitudinal data}
\usage{
prctilemlx(r, col = NULL, number = 8, level = 80, plot = TRUE,
  color = "purple", group = NULL, facet = TRUE, labels = NULL,
  band = NULL)
}
\arguments{
\item{r}{a data frame with a column \samp{id}, a column \samp{time} and a column with values.
The times should be the same for each individual.}

\item{col}{a vector of 3 column numbers: (\samp{id}, \samp{time/x}, \samp{y}. Default = c(1, 2,3).}

\item{number}{the number of intervals (i.e. the number of percentiles minus 1).}

\item{level}{the largest interval (i.e. the difference between the lowest and the highest percentile).}

\item{plot}{if \code{TRUE} the empirical distribution is displayed, if \code{FALSE}
the values are returned}

\item{color}{a color to be used for the plots (default="purple")}

\item{group}{variable to be used for defining groups (by default, \samp{group} is used when it exists)}

\item{facet}{makes subplots for different groups if \code{TRUE}}

\item{labels}{vector of strings}

\item{band}{is deprecated (use number and level instead) ; a list with two fields
\itemize{
  \item \code{number} the number of intervals (i.e. the number of percentiles minus 1).
  \item \code{level} the largest interval (i.e. the difference between the lowest and the highest percentile).
}}
}
\value{
a ggplot object if \code{plot=TRUE} ; otherwise, a list with fields:
\itemize{
  \item proba a vector of probabilities of length \code{band$number+1} 
  \item color a vector of colors used for the plot of length \code{band$number}
  \item y a data frame with the values of the empirical percentiles computed at each time point
}
}
\description{
Compute and display percentiles of the empiricial distribution of longitudinal data.
}
\details{
See http://simulx.webpopix.org/mlxr/prctilemlx/ for more details.
}
\examples{
\dontrun{
  myModel <- inlineModel("
  [LONGITUDINAL]
  input = {ka, V, Cl}
  EQUATION:
  C = pkmodel(ka,V,Cl)
  
  [INDIVIDUAL]
  input = {ka_pop, V_pop, Cl_pop, omega_ka, omega_V, omega_Cl}
  DEFINITION:
  ka = {distribution=lognormal, reference=ka_pop, sd=omega_ka}
  V  = {distribution=lognormal, reference=V_pop,  sd=omega_V }
  Cl = {distribution=lognormal, reference=Cl_pop, sd=omega_Cl}
  ")
  
  N=2000
  
  pop.param   <- c(
    ka_pop  = 1,    omega_ka  = 0.5,
    V_pop   = 10,   omega_V   = 0.4,
    Cl_pop  = 1,    omega_Cl  = 0.3)
    
  res <- simulx(model     = myModel,
                parameter = pop.param,
                treatment = list(time=0, amount=100),
                group     = list(size=N, level='individual'),
                output    = list(name='C', time=seq(0,24,by=0.1)))
  # res$C is a data.frame with 2000x241=482000 rows and 3 columns
  head(res$C)
  # we can display the empirical percentiles of C using the default 
  # settings (i.e. percentiles of order 10\%, 20\%, ... 90\%)
  prctilemlx(res$C)
  # The 3 quartiles (i.e. percentiles of order 25\%, 50\% and 75\%) are displayed by 
  # selecting a 50\% interval splitted into 2 subintervals
  prctilemlx(res$C, number=2, level=50)
  # A one 90\% interval can be displayed using only one interval
  prctilemlx(res$C, number=1, level=90)
  # or 75 subintervals in order to better represent the continuous distribution 
  # of the data within this interval
  prctilemlx(res$C, number=75, level=90)
  # prctilemlx produces a ggplot object that can be modified
  pl <- prctilemlx(res$C, number=4, level=80) 
  pl + ylab("concentration") + ggtitle("predictive distribution")
  # The percentiles are not plotted by setting plot=FALSE
  pr.out <- prctilemlx(res$C, number=4, level=80, plot=FALSE)
  print(pr.out$proba)
  print(pr.out$color)
  print(pr.out$y[1:5,])
}
}
