% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_get_minimal_fit_data}
\alias{h_get_minimal_fit_data}
\title{Obtain the Minimal Dataset Needed for an \code{mmrm} Fit}
\usage{
h_get_minimal_fit_data(fit)
}
\arguments{
\item{fit}{(\code{mmrm})\cr a fitted \code{mmrm} model.}
}
\value{
A data frame: a subset of the columns the dataset underlying \code{fit}
(i.e., \code{fit$data}):
\itemize{
\item The response column.
\item The column denoting the visit index.
\item The column denoting the subject.
\item The column denoting the subject's grouping (e.g., study arm).
\item All other predictors not already specified.

Columns that were not used are excluded.
}
}
\description{
Grab the dataset underlying an \code{mmrm} fit and select only the used columns.
}
\details{
Grabs the response variable along with the predictors named in
\code{fit$formula_parts}.
}
\keyword{internal}
