% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_joined_between.R
\name{mnis_joined_between}
\alias{mnis_joined_between}
\title{mnis_joined_between}
\usage{
mnis_joined_between(start_date = "1900-01-01", end_date = Sys.Date(),
  house = "all", party = NULL, eligible = "all", tidy = TRUE,
  tidy_style = "snake_case")
}
\arguments{
\item{start_date}{The start date of the search, Accepts character values in "YYYY-MM-DD" format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}. Defaults to '1900-01-01'.}

\item{end_date}{The end date of the search. Accepts character values in "YYYY-MM-DD" format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}. Defaults to the current date.}

\item{house}{The house to which the member belongs. Accepts one of 'all', 'lords' and 'commons', defaults to 'all'.}

\item{party}{The party to which a member belongs. Defaults to NULL.}

\item{eligible}{If the member is currently eligible to sit. Accepts one of 'all', 'current', 'former', defaults to 'all'.}

\item{tidy}{Fix the variable names in the tibble to remove non-alphanumeric characters and superfluous text, and convert variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy=TRUE. Accepts one of "snake_case", "camelCase" and "period.case". Defaults to "snake_case".}
}
\description{
Function returns all members who took their seats in the house between two given dates. The function requests data in JSON format and parses it to a tibble. The
}
\examples{
\dontrun{
x <- mnis_joined_between(start_date = '2015-01-01', end_date ='2017-01-01', party='labour')

}
}
\keyword{mnis}
