% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlme_model.R
\name{nlmeModel}
\alias{nlmeModel}
\title{MNREAD data fitting using a nonlinear mixed-effect (NLME) modeling.}
\usage{
nlmeModel(
  data,
  print_size,
  viewing_distance,
  reading_time,
  errors,
  subjectID,
  nested = NULL,
  group = NULL
)
}
\arguments{
\item{data}{The name of your dataframe}

\item{print_size}{The variable that contains print size values for each sentence (print size uncorrected for viewing distance)}

\item{viewing_distance}{The variable that contains the viewing distance value used for testing}

\item{reading_time}{The variable that contains the reading time for each sentence}

\item{errors}{The variable that contains the number of errors for each sentence}

\item{subjectID}{The variable that contains the subject identifiers}

\item{nested}{Optional argument to build a model with a nested structure. 'nested' specifies which variable should be nested within subject. Default is NULL.}

\item{group}{Optional argument to build a model with a grouped structure. 'group' specifies which variable should be used as grouping argument. Default is NULL}
}
\value{
The function returns a list of two objects: 
  \itemize{
  \item an object of class dataframe which is a cleaned version of the dataset called by the function to fit the model
  \item an object of class nlme returned by the function \code{\link{nlme}} 
  }
}
\description{
This function uses a nonlinear mixed effects model (NLME), as described in Cheung et al. 2008, 
where variations across individuals are modeled as random effects. 
This function estimates and returns the NLME model while performing print size correction for non-standard testing viewing distance (ie. different than 40 cm).
}
\section{Notes}{

For subjects with incomplete data, warning messages might appear in the console. However, the NLME model will run, 
using supporting data from the rest of the population.

This functions supports nested, grouped and nested + grouped structures. 

If needed, the nlme object returned can be further explored using generic functions from the nlme package.

This function implements several functions from the nlme package to build the NLME model:
  \itemize{
  \item it first calls groupedData() to format the dataset in order to match the desired structure
  \item it then uses nlsList() to generate starting values
  \item it finally calls nlme() to build the model 
  }
 
For more details on the nlme fit, see:\\
Cheung SH, Kallie CS, Legge GE, Cheong AM. Nonlinear mixed-effects modeling of MNREAD data. 
Invest Ophthalmol Vis Sci. 2008;49:828–835. doi: 10.1167/iovs.07-0555.
}

\section{Warning}{

For the function to run properly, please make sure that variables are of the following classes:
  \itemize{
  \item \strong{print_size} -> numeric
  \item \strong{viewing_distance} -> integer
  \item \strong{reading_time} -> numeric
  \item \strong{errors} -> integer
  }
  
The optional arguments "nested" and "group" should only be specified when they are needed. 
In case they are called and set to NULL, the function will not run and will return an error.
}

\examples{
# inspect the structure of the dataframe
head(data_low_vision, 10)

#------

# restrict dataset to one MNREAD test per subject (regular polarity only)
data_regular <- data_low_vision \%>\%
    filter (polarity == "regular")

# run the NLME model for data grouped by subject
\donttest{ model_simple <- nlmeModel(data_regular, ps, vd, rt, err, subject) }

# to print the model summary
\donttest{ summary(model_simple[[2]]) }

# to print the first 3 rows of the cleaned dataset containing the raw data and used to run the model
\donttest{ head(model_simple[[1]], 3) }

#------

# run the NLME model on the whole dataset with polarity nested within subject
\donttest{ model_nested <- lmeModel(data_low_vision, ps, vd, rt, err, subject,
                                   nested = polarity) }

#------

# run theNLME model on the whole dataset with polarity nested within subject 
# and grouped based on treatment
\donttest{ model_nested_grouped <- nlmeModel(data_low_vision, ps, vd, rt, err, subject,
                                            nested = polarity, group = treatment) }



}
\seealso{
\code{\link{nlmeParam}} to estimate Maximum Reading Speed (MRS) and Critical Print Size (CPS) from the NLME model
 
 \code{\link{nlmeCurve}} to plot the individual MNREAD curves estimated from the NLME model
}
