% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlmePredict_RS.R
\name{nlmePredict_RS}
\alias{nlmePredict_RS}
\title{Estimation of the reading speed achieved for a given print size.}
\usage{
nlmePredict_RS(nlme.model, print.size)
}
\arguments{
\item{nlme.model}{The object returned by \code{\link{nlmeModel}}}

\item{print.size}{A specific value of print size in logMAR}
}
\value{
The function returns a dataframe with a with two variables:
 \itemize{
  \item "print_size" -> the print size value passed to the function (in logMAR) 
  \item "estimated_reading_speed" -> the reading speed achieved at the specified print size as estimated by the NLME model (in words/min)
  }
}
\description{
This function uses results from the NLME model created with \code{\link{nlmeModel}} to estimate the reading speed achieved for a specific print size.
}
\section{Notes}{

The values of print size returned have been corrected for non-standard testing viewing distance.

For more details on the nlme fit, see:\\
Cheung SH, Kallie CS, Legge GE, Cheong AM. Nonlinear mixed-effects modeling of MNREAD data. 
Invest Ophthalmol Vis Sci. 2008;49:828–835. doi: 10.1167/iovs.07-0555.
}

\examples{
# inspect the structure of the dataframe
head(data_low_vision, 10)

#------

# restrict dataset to one MNREAD test per subject (regular polarity only)
data_regular <- data_low_vision \%>\%
    filter (polarity == "regular")

# run the NLME model for data grouped by subject
\donttest{ nlme_model <- nlmeModel(data_regular, ps, vd, rt, err, subject) }

#------

# extract reading speed achieved at 1.6 logMAR according to the NLME fit 
\donttest{ nlmePredict_RS(nlme_model, 1.6) }



}
\seealso{
\code{\link{nlmeModel}} to fit MNREAD data using a nonlinear mixed-effect (NLME) modeling

\code{\link{nlmeParam}} to estimate Maximum Reading Speed (MRS) and Critical Print Size (CPS) from the NLME model
 
\code{\link{nlmeCurve}} to plot the individual MNREAD curves estimated from the NLME model
}
