% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{SR}
\alias{SR}
\title{statistic of the Székely-Rizzo test}
\usage{
SR(data, abb = 1e-08)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}

\item{abb}{Stop criterium.}
}
\value{
value of the test statistic.
}
\description{
This function returns the value of the statistic of the test of multivariate normality (also called \emph{energy test}) as in Székely and Rizzo (2005). Note that the scaled residuals use another scaling in the estimator of the covariance matrix as the other functions of the package \code{mnt}!
It is equivalent to the function \code{\link[energy]{mvnorm.e}}.
}
\examples{
SR(MASS::mvrnorm(50,c(0,1),diag(1,2)))

}
\references{
Székely, G., and Rizzo, M. (2005), A new test for multivariate normality, J. Multiv. Anal., 93:58–80, \href{https://doi.org/10.1016/j.jmva.2003.12.002}{DOI}
}
\seealso{
\code{\link[energy]{mvnorm.e}}
}
