% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multNormTest.R
\name{test.HZ}
\alias{test.HZ}
\title{The Henze-Zirkler test}
\usage{
test.HZ(data, MC.rep = 10000, alpha = 0.05)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}

\item{MC.rep}{number of repetitions for the Monte Carlo simulation of the critical value}

\item{alpha}{level of significance of the test}
}
\value{
a list containing the value of the test statistic, the approximated critical value and a test decision on the significance level \code{alpha}: \cr
\describe{
        \item{\code{$Test}}{name of the test.}
        \item{\code{$param}}{value tuning parameter.}
        \item{\code{$Test.value}}{the value of the test statistic.}
        \item{\code{$cv}}{the approximated critical value.}
        \item{\code{$Decision}}{the comparison of the critical value and the value of the test statistic.}#' }
}
\description{
Performs the test of multivariate normality of Henze and Zirkler (1990).
}
\details{
A \code{\link{BHEP}} test is performed with tuning parameter \eqn{\beta} chosen in dependence of the sample size n and the dimension d, namely \deqn{\beta=\frac{((2d+1)n/4)^(1/(d+4))}{\sqrt{2}}.}
}
\examples{
test.HZ(MASS::mvrnorm(50,c(0,1),diag(1,2)),MC.rep=500)

}
\references{
Henze, N., Zirkler, B. (1990), A class of invariant consistent tests for multivariate normality, Commun.-Statist. - Th. Meth., 19:3595-3617, \href{https://doi.org/10.1080/03610929008830400}{DOI}
}
\seealso{
\code{\link{HZ}}
}
