% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobr.R
\name{plot_rarefaction}
\alias{plot_rarefaction}
\title{Plot rarefaction curves for each treatment group}
\usage{
plot_rarefaction(
  mob_in,
  env_var,
  method,
  dens_ratio = 1,
  pooled = TRUE,
  spat_algo = NULL,
  col = NULL,
  lwd = 3,
  log = "",
  leg_loc = "topleft",
  ...
)
}
\arguments{
\item{mob_in}{a 'mob_in' class object produced by 'make_mob_in'}

\item{env_var}{a string that specifies the column name in mob_in$env that
specifies the grouping variable.}

\item{method}{a character string that specifies the method of rarefaction 
  curve construction it can be one of the following: 
\itemize{
    \item \code{'IBR'} ... individual-based rarefaction in which species
    are accumulated by randomly sampling individuals
    \item \code{'SBR'} ... sample-based rarefaction in which species are 
    accumulated by randomly sampling samples (i.e., plots). Note that within plot spatial 
    aggregation is maintained with this approach. Although this curve
    is implemented here, it is not used in the current version of the MoB framework
    \item \code{'nsSBR'} ... non-spatial, sampled-based rarefaction in which
    species are accumulated by randomly sampling samples that represent a 
    spatially random sample of individuals (i.e., no with-in plot spatial 
    aggregation). The argument \code{dens_ratio} must also be set otherwise 
    this sampling results in a curve identical to the IBR (see Details). 
    \item \code{'sSBR'} ... spatial sample-based rarefaction in which species 
    are accumulated by including spatially proximate samples first. 
}}

\item{dens_ratio}{the ratio of individual density between a reference group
and the community data (i.e., x) under consideration. This argument is
used to rescale the rarefaction curve when estimating the effect of
individual density on group differences in richness.}

\item{pooled}{Boolean specifying if samples should be pooled at the group
level or not. Defaults to TRUE. This argument only applies when
the individual based rarefaction is used (i.e., \code{method = 'indiv'})}

\item{spat_algo}{character string that can be either: \code{'kNN'} or \code{'kNCN'}
for k-nearest neighbor and k-nearest centroid neighbor sampling 
respectively. It defaults to k-nearest neighbor which is a 
more computationally efficient algorithm that closely approximates the 
potentially more correct k-NCN algo (see Details).}

\item{col}{optional vector of colors.}

\item{lwd}{a number which specifies the width of the lines}

\item{log}{a string that specifies if any axes are to be log transformed, 
options include 'x', 'y' or 'xy' in which either the x-axis, y-axis, or
both axes are log transformed respectively}

\item{leg_loc}{a string that specifies the location of the legend, 
options include: 'lowerleft', 'topleft', 'loweright','topright'}

\item{...}{other arguments to provide to \code{\link[mobr]{rarefaction}}}
}
\description{
Plot rarefaction curves for each treatment group
}
\examples{
data(inv_comm)
data(inv_plot_attr)
inv_mob_in = make_mob_in(inv_comm, inv_plot_attr, coord_names = c('x', 'y'))
# random individual based rarefaction curves
plot_rarefaction(inv_mob_in, 'group', 'IBR',
                 pooled=TRUE, leg_loc='bottomright')
plot_rarefaction(inv_mob_in, 'group', 'IBR',
                 pooled=FALSE, log='x')
# random sample based rarefaction curves 
plot_rarefaction(inv_mob_in, 'group', 'SBR', log='xy')
# spatial sample based rarefaction curves 
plot_rarefaction(inv_mob_in, 'group', 'sSBR', log='xy')
}
