% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diversity_Area_Relationships.R
\name{dist_decay_quadrats}
\alias{dist_decay_quadrats}
\title{Distance decay of similarity with user-defined quadrats}
\usage{
dist_decay_quadrats(samples, method = "bray", binary = FALSE)
}
\arguments{
\item{samples}{A list given by \code{\link{sample_quadrats}}}

\item{method}{Choice of (dis)similarity index. See \code{\link[vegan]{vegdist}}}

\item{binary}{Perform presence/absence standardization before analysis?
See \code{\link[vegan]{vegdist}}}
}
\value{
Object of class  \code{dist_decay}: a dataframe with distances between
subplot pairs and the respective similarity indices.
}
\description{
Estimate pairwise similarities of communities in quadrats as
function of distance. The function allows the user to compute
distance decay between the quadrats of his/her choice.
}
\examples{
sim_com1 <- sim_thomas_community(100, 10000, sigma = 0.1, mother_points = 2)
oldpar<- par(mfrow=c(1,2))
samples <- sample_quadrats(sim_com1, avoid_overlap = TRUE, quadrat_area=.005,
                           n_quadrats = 50, plot = TRUE)
dd_quadrats <- dist_decay_quadrats(samples)
plot(dd_quadrats)
par(oldpar)

}
