% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/min_bpp.R
\name{min_prior}
\alias{min_prior}
\title{Minimum Prior}
\usage{
min_prior(bic, bpp_target, target_name = "original")
}
\arguments{
\item{bic}{A named vector of BIC values
for a set of models.}

\item{bpp_target}{A value from zero
to 1. The desired BIC posterior
probability.}

\item{target_name}{The name of the
original model, as appeared in the
names of \code{bic}.}
}
\value{
A scalar. The required prior
probability.
}
\description{
Find the minimum prior
probability required to achieve
the desired BIC posterior
probability.
}
\details{
It assumes that all models other than
the original model have the same prior
probabilities.

This function is called by
\code{\link[=model_set]{model_set()}} or \code{\link[=print.model_set]{print.model_set()}}
and usually users do
not need to call it. It is exported
for advanced users.
}
\examples{

library(lavaan)

dat <- dat_path_model

mod <-
"
x3 ~ a*x1 + b*x2
x4 ~ a*x1
ab := a*b
"

fit <- sem(mod, dat_path_model, fixed.x = TRUE)

out <- model_set(fit)
min_prior(out$bic, bpp_target = .8)

}
\references{
Wu, H., Cheung, S. F., & Leung, S. O.
(2020). Simple use of BIC to assess
model selection uncertainty: An
illustration using mediation and
moderation models.
\emph{Multivariate Behavioral Research},
\emph{55}(1), 1--16.
\doi{10.1080/00273171.2019.1574546}
}
\seealso{
\code{\link[=model_set]{model_set()}} and
\code{\link[=print.model_set]{print.model_set()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
