% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control-par.R
\name{control_fit_workflowset}
\alias{control_fit_workflowset}
\title{Control aspects of the \code{modeltime_fit_workflowset()} process.}
\usage{
control_fit_workflowset(
  verbose = FALSE,
  allow_par = FALSE,
  cores = -1,
  packages = NULL
)
}
\arguments{
\item{verbose}{Logical to control printing.}

\item{allow_par}{Logical to allow parallel computation. Default: \code{FALSE} (single threaded).}

\item{cores}{Number of cores for computation. If -1, uses all available physical cores.
Default: \code{-1}.}

\item{packages}{An optional character string of additional R package names that should be loaded
during parallel processing.
\itemize{
\item Packages in your namespace are loaded by default
\item Key Packages are loaded by default: \code{tidymodels}, \code{parsnip}, \code{modeltime}, \code{dplyr}, \code{stats}, \code{lubridate} and \code{timetk}.
}}
}
\value{
A List with the control settings.
}
\description{
Control aspects of the \code{modeltime_fit_workflowset()} process.
}
\examples{
#' # No parallel processing
control_fit_workflowset()

# With parallel processing
control_fit_workflowset(allow_par = TRUE)

}
\seealso{
\code{\link[=modeltime_fit_workflowset]{modeltime_fit_workflowset()}}
}
