% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETCt.R
\name{ETCt}
\alias{ETCt}
\title{Tool to computate the Expected Total Cost vector for a Continuous Time Markov Chain, CTMC.}
\usage{
ETCt(R, c, t, epsilon = 0.01)
}
\arguments{
\item{R}{numeric, represents the rate matrix of a CTMC.}

\item{c}{vector, represents the costs of the states of a CTMC.}

\item{t}{numeric, represents the length of time.}

\item{epsilon}{numeric, represents the error bound of the approximation of M(t). Default value is 0.01.}
}
\description{
\code{ETCt} is used to obtain the Expected Total Cost vector up to t of a homogeneous continuous time Markov chain.
}
\examples{
library(modesto)
R <- matrix(c(0,1,0,0,0, 1/72,0,1,0,0, 0,2/72,0,1,0, 0,0,3/72,0,1/2, 0,0,0,4/72,0),5,5,byrow=TRUE)
ETCt(R,c(-80,-15,50,125,200),t=24,epsilon=0.001) # A four states CTMC example
}
\references{
Ross, S, Introduction to Probability Models, Eleven Edition. Academic Press, 2014.

Kulkarni V, Introduction to modeling and analysis of stochastic systems. Second Edition. Springer-Verlag, 2011.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
