% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_modsem_da.R,
%   R/generics_modsem_mplus.R, R/generics_modsem_pi.R
\name{summary.modsem_da}
\alias{summary.modsem_da}
\alias{summary.modsem_mplus}
\alias{summary.modsem_pi}
\title{summary for modsem objects}
\usage{
\method{summary}{modsem_da}(
  object,
  H0 = is_interaction_model(object),
  verbose = interactive(),
  r.squared = TRUE,
  fit = FALSE,
  adjusted.stat = FALSE,
  digits = 3,
  scientific = FALSE,
  ci = FALSE,
  standardized = FALSE,
  centered = FALSE,
  monte.carlo = FALSE,
  mc.reps = 10000,
  loadings = TRUE,
  regressions = TRUE,
  covariances = TRUE,
  intercepts = TRUE,
  variances = TRUE,
  var.interaction = FALSE,
  ...
)

\method{summary}{modsem_mplus}(
  object,
  scientific = FALSE,
  standardized = FALSE,
  ci = FALSE,
  digits = 3,
  loadings = TRUE,
  regressions = TRUE,
  covariances = TRUE,
  intercepts = TRUE,
  variances = TRUE,
  ...
)

\method{summary}{modsem_pi}(
  object,
  H0 = is_interaction_model(object),
  r.squared = TRUE,
  adjusted.stat = FALSE,
  digits = 3,
  scientific = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{modsem object to summarized}

\item{H0}{Should the baseline model be estimated, and used to produce
comparative fit?}

\item{verbose}{Should messages be printed?}

\item{r.squared}{Calculate R-squared.}

\item{fit}{Print additional fit measures.}

\item{adjusted.stat}{Should sample size corrected/adjustes AIC and BIC be reported?}

\item{digits}{Number of digits for printed numerical values}

\item{scientific}{Should scientific format be used for p-values?}

\item{ci}{print confidence intervals}

\item{standardized}{standardize estimates}

\item{centered}{Print mean centered estimates.}

\item{monte.carlo}{Should Monte Carlo bootstrapped standard errors be used? Only
relevant if \code{standardized = TRUE}. If \code{FALSE} delta method is used instead.}

\item{mc.reps}{Number of Monte Carlo repetitions. Only relevant if \code{monte.carlo = TRUE},
and \code{standardized = TRUE}.}

\item{loadings}{print loadings}

\item{regressions}{print regressions}

\item{covariances}{print covariances}

\item{intercepts}{print intercepts}

\item{variances}{print variances}

\item{var.interaction}{If FALSE variances for interaction terms will be removed
from the output.}

\item{...}{arguments passed to lavaan::summary()}
}
\description{
summary for modsem objects

summary for modsem objects

summary for modsem objects
}
\examples{
\dontrun{
m1 <- "
 # Outer Model
 X =~ x1 + x2 + x3
 Y =~ y1 + y2 + y3
 Z =~ z1 + z2 + z3

 # Inner model
 Y ~ X + Z + X:Z
"

est1 <- modsem(m1, oneInt, "qml")
summary(est1, ci = TRUE, scientific = TRUE)
}
}
