% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_interaction.R
\name{plot_surface}
\alias{plot_surface}
\title{Plot Surface for Interaction Effects}
\usage{
plot_surface(
  x,
  z,
  y,
  xz = NULL,
  model,
  min_x = -3,
  max_x = 3,
  min_z = -3,
  max_z = 3,
  detail = 0.01,
  ...
)
}
\arguments{
\item{x}{A character string specifying the name of the first predictor variable.}

\item{z}{A character string specifying the name of the second predictor variable.}

\item{y}{A character string specifying the name of the outcome variable.}

\item{xz}{Optional. A character string or vector specifying the interaction term between `x` and `z`.
If `NULL`, the interaction term is constructed as `paste(x, z, sep = ":")` and adjusted for specific model classes.}

\item{model}{A model object of class `'modsem_pi'`, `'modsem_da'`, `'modsem_mplus'`, or `'lavaan'`. The model should
include paths for the predictors (`x`, `z`, and `xz`) to the outcome (`y`).}

\item{min_x}{Numeric. Minimum value of `x` in z-scores. Default is -3.}

\item{max_x}{Numeric. Maximum value of `x` in z-scores. Default is 3.}

\item{min_z}{Numeric. Minimum value of `z` in z-scores. Default is -3.}

\item{max_z}{Numeric. Maximum value of `z` in z-scores. Default is 3.}

\item{detail}{Numeric. Step size for the grid of `x` and `z` values, determining the resolution of the surface.
Smaller values increase plot resolution. Default is `1e-2`.}

\item{...}{Additional arguments passed to `plotly::plot_ly`.}
}
\value{
A `plotly` surface plot object displaying the predicted values of `y` across the grid of `x` and `z` values.
  The color bar shows the values of `y`.
}
\description{
Generates a 3D surface plot to visualize the interaction effect of two variables (`x` and `z`) on an outcome (`y`)
using parameter estimates from a supported model object (e.g., `lavaan` or `modsem`).
The function allows specifying ranges for `x` and `z` in standardized z-scores, which are then transformed
back to the original scale based on their means and standard deviations.
}
\details{
The input `min_x`, `max_x`, `min_z`, and `max_z` define the range of `x` and `z` values in z-scores.
These are scaled by the standard deviations and shifted by the means of the respective variables, obtained
from the model parameter table. The resulting surface shows the predicted values of `y` over the grid of `x` and `z`.

The function supports models of class `modsem` (with subclasses `modsem_pi`, `modsem_da`, `modsem_mplus`) and `lavaan`.
For `lavaan` models, it is not designed for multigroup models, and a warning will be issued if multiple groups are detected.
}
\note{
The interaction term (`xz`) may need to be manually specified for some models. For non-`lavaan` models,
interaction terms may have their separator (`:`) removed based on circumstances.
}
\examples{
\dontrun{
m1 <- "
# Outer Model
  X =~ x1
  X =~ x2 + x3
  Z =~ z1 + z2 + z3
  Y =~ y1 + y2 + y3

# Inner model
  Y ~ X + Z + X:Z
"
est1 <- modsem(m1, data = oneInt)
plot_surface("X", "Z", "Y", model = est1)

tpb <- "
# Outer Model (Based on Hagger et al., 2007)
  ATT =~ att1 + att2 + att3 + att4 + att5
  SN =~ sn1 + sn2
  PBC =~ pbc1 + pbc2 + pbc3
  INT =~ int1 + int2 + int3
  BEH =~ b1 + b2

# Inner Model (Based on Steinmetz et al., 2011)
  # Causal Relationsships
  INT ~ ATT + SN + PBC
  BEH ~ INT + PBC
  # BEH ~ ATT:PBC
  BEH ~ PBC:INT
  # BEH ~ PBC:PBC
"

est2 <- modsem(tpb, TPB, method = "lms")
plot_surface(x = "INT", z = "PBC", y = "BEH", model = est1)
}

}
