% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_metrics.R
\name{igd}
\alias{igd}
\title{IGD: Inverted Generational Distance}
\usage{
igd(aps, tps, method = "manhattan", norm = TRUE)
}
\arguments{
\item{aps}{An object of type \code{\link{ps}} containing the "actual" Pareto front}

\item{tps}{An object of type \code{\link{ps}} containing the "true" Pareto front}

\item{method}{String stating which distance measure to be used. This must be one of:
"euclidean" or "manhattan" (default).}

\item{norm}{Logical (default: \code{TRUE}) indicating if both fronts should be normalized.}
}
\value{
returns the IGD metric
}
\description{
The IGD is a performance measure function of Pareto front fidelity and
corresponds to the average distance between all designs in the true set and
the closest design of the current set. Thus, the lower the IGD value, the
better the front is.
}
\examples{
\dontrun{
aps <- ps(matrix(rnorm(1:1000),ncol=2))
tps <- ps(matrix(rnorm(1:2000),ncol=2))
igd(aps,tps)

tps <-nowacki_beam_tps$set[1:50 * 10,]
aps <- tps * 1.2
igd(aps,tps)
}
}
\references{
Shimoyama, K., Jeong, S., & Obayashi, S. (2013, June).
  Kriging-surrogate-based optimization considering expected hypervolume
  improvement in non-constrained many-objective test problems. In 2013 IEEE
  \emph{Congress on Evolutionary Computation} (pp. 658-665). IEEE.
}
