% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_PCT_BINNING.R
\name{pct.bin}
\alias{pct.bin}
\title{Monotonic binning based on percentiles}
\usage{
pct.bin(
  x,
  y,
  sc = c(NA, NaN, Inf),
  sc.method = "together",
  g = 15,
  y.type = NA,
  woe.trend = TRUE,
  force.trend = NA
)
}
\arguments{
\item{x}{Numeric vector to be binned.}

\item{y}{Numeric target vector (binary or continuous).}

\item{sc}{Numeric vector with special case elements. Default values are \code{c(NA, NaN, Inf)}.
Recommendation is to keep the default values always and add new ones if needed. Otherwise, if these values exist
in \code{x} and are not defined in the \code{sc} list some statistics cannot be calculated properly.}

\item{sc.method}{Define how special cases will be treated, all together or in separate bins.
Possible values are \code{"together", "separately"}.}

\item{g}{Number of starting groups. Default is 15.}

\item{y.type}{Type of \code{y}, possible options are \code{"bina"} (binary) and \code{"cont"} (continuous).
If default value is passed, then algorithm will identify if y is 0/1 or continuous variable.}

\item{woe.trend}{Applied only for a continuous target (\code{y}) as weights of evidence (WoE) trend check. Default is TRUE.}

\item{force.trend}{If the expected trend should be forced. Possible values: \code{"i"} for
increasing trend (\code{y} increases with increase of \code{x}), \code{"d"} for decreasing trend
(\code{y} decreases with decrease of \code{x}). Default value is \code{NA}.
If the default value is passed, algorithm will stop if perfect negative or positive correlation (Spearman) is achieved
between average \code{y} and average \code{x} per bin. Otherwise, it will stop only if the forced trend is achieved.}
}
\value{
The command \code{pct.bin} generates a list of two objects. The first object, data frame \code{summary.tbl}
presents a summary table of final binning, while \code{x.trans} is a vector of discretized values.
In case of single unique value for \code{x} or \code{y} of complete cases (cases different than special cases),
it will return data frame with info.
}
\description{
\code{pct.bin} implements percentile-based monotonic binning by the iterative discretization.
}
\examples{
suppressMessages(library(monobin))
data(gcd)
#binary target
mat.bin <- pct.bin(x = gcd$maturity, y = gcd$qual)
mat.bin[[1]]
table(mat.bin[[2]])
#continuous target, separate groups for special cases
set.seed(123)
gcd$age.d <- gcd$age
gcd$age.d[sample(1:nrow(gcd), 10)] <- NA
gcd$age.d[sample(1:nrow(gcd), 3)] <- 9999999999
age.d.bin <- pct.bin(x = gcd$age.d, 
			   	y = gcd$qual, 
			   	sc = c(NA, NaN, Inf, 9999999999), 
			  	sc.method = "separately",
			   	force.trend = "d")
age.d.bin[[1]]
gcd$age.d.bin <- age.d.bin[[2]]
gcd \%>\% group_by(age.d.bin) \%>\% summarise(n = n(), y.avg = mean(qual))

}
