% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vorob.R
\name{vorob_t}
\alias{vorob_t}
\alias{vorob_dev}
\title{Vorob'ev threshold, expectation and deviation}
\usage{
vorob_t(x, sets, reference, maximise = FALSE)

vorob_dev(x, sets, reference, ve = NULL, maximise = FALSE)
}
\arguments{
\item{x}{\code{matrix()}|\code{data.frame()}\cr Matrix or data frame of numerical
values that represents multiple sets of points, where each row represents
a point. If \code{sets} is missing, the last column of \code{x} gives the sets.}

\item{sets}{\code{integer()}\cr Vector that indicates the set of each point in
\code{x}. If missing, the last column of \code{x} is used instead.}

\item{reference}{\code{numeric()}\cr Reference point as a vector of numerical
values.}

\item{maximise}{\code{logical()}\cr Whether the objectives must be maximised
instead of minimised. Either a single logical value that applies to all
objectives or a vector of logical values, with one value per objective.}

\item{ve}{\code{matrix()}\cr Vorob'ev expectation, e.g., as returned by \code{\link[=vorob_t]{vorob_t()}}.}
}
\value{
\code{vorob_t} returns a list with elements \code{threshold},
\code{ve}, and \code{avg_hyp} (average hypervolume)

\code{vorob_dev} returns the Vorob'ev deviation.
}
\description{
Compute Vorob'ev threshold, expectation and deviation. Also, displaying the
symmetric deviation function is possible.  The symmetric deviation
function is the probability for a given target in the objective space to
belong to the symmetric difference between the Vorob'ev expectation and a
realization of the (random) attained set.
}
\details{
Let \eqn{\mathcal{A} = \{A_1, \dots, A_n\}} be a multi-set of \eqn{n} sets
\eqn{A_i \subset \mathbb{R}^d} of mutually nondominated vectors, with finite
(but not necessarily equal) cardinality.  If bounded by a reference point
\eqn{\vec{r}} that is strictly dominated by any point in any set, then these
sets can be seen a samples from a random closed set
\citep{Molchanov2005theory}.

Let the \eqn{\beta}-quantile be the subset of the empirical attainment
function \eqn{\mathcal{Q}_\beta = \{\vec{z}\in \mathbb{R}^d :
\hat{\alpha}_{\mathcal{A}}(\vec{z}) \geq \beta\}}.

The Vorob'ev \emph{expectation} is the \eqn{\beta^{*}}-quantile set
\eqn{\mathcal{Q}_{\beta^{*}}} such that the mean value hypervolume of the
sets is equal (or as close as possible) to the hypervolume of
\eqn{\mathcal{Q}_{\beta^{*}}}, that is, \eqn{\text{hyp}(\mathcal{Q}_\beta)
\leq \mathbb{E}[\text{hyp}(\mathcal{A})] \leq
\text{hyp}(\mathcal{Q}_{\beta^{*}})}, \eqn{\forall \beta > \beta^{*}}. Thus,
the Vorob'ev expectation provides a definition of the notion of \emph{mean}
nondominated set.

The value \eqn{\beta^{*} \in [0,1]} is called the Vorob'ev
\emph{threshold}. Large differences from the median quantile (0.5) indicate a
skewed distribution of \eqn{\mathcal{A}}.

The Vorob'ev \emph{deviation} is the mean hypervolume of the symmetric difference
between the Vorob'ev expectation and any set in \eqn{\mathcal{A}}, that is,
\eqn{\mathbb{E}[\text{hyp}(\mathcal{Q}_{\beta^{*}} \ominus \mathcal{A})]},
where the symmetric difference is defined as \eqn{A \ominus B = (A \setminus
B) \cup (B \setminus A)}.  Low deviation values indicate that the sets are
very similar, in terms of the location of the weakly dominated space, to the
Vorob'ev expectation.

For more background, see
\citet{BinGinRou2015gaupar,Molchanov2005theory,CheGinBecMol2013moda}.
}
\references{
\insertAllCited{}
}
\author{
Mickael Binois
}
\concept{eaf}
\examples{
data(CPFs)
res <- vorob_t(CPFs, reference = c(2, 200))
res$threshold
res$avg_hyp
# Now print Vorob'ev deviation
vd <- vorob_dev(CPFs, ve = res$ve, reference = c(2, 200))
vd
}
