% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hv.R
\name{hv_contributions}
\alias{hv_contributions}
\title{Hypervolume contribution of a set of points}
\usage{
hv_contributions(x, reference, maximise = FALSE, ignore_dominated = TRUE)
}
\arguments{
\item{x}{\code{matrix()}|\code{data.frame()}\cr Matrix or data frame of numerical
values, where each row gives the coordinates of a point.}

\item{reference}{\code{numeric()}\cr Reference point as a vector of numerical
values.}

\item{maximise}{\code{logical()}\cr Whether the objectives must be maximised
instead of minimised. Either a single logical value that applies to all
objectives or a vector of logical values, with one value per objective.}

\item{ignore_dominated}{\code{logical(1)}\cr Whether dominated points are ignored
when computing the contribution of nondominated points.  The value of this
parameter has an effect on the return values only if the input contains
dominated points. Setting this to \code{FALSE} slows down the computation
significantly.  See the Notes below for a detailed explanation.}
}
\value{
\code{numeric()}\cr A numerical vector
}
\description{
Computes the hypervolume contribution of each point of a set of points with
respect to a given reference point. Duplicated and dominated points have
zero contribution.  By default, dominated points are ignored, that is, they
do not affect the contribution of other points.  See the Notes below for
more details.  For details about the hypervolume, see \code{\link[=hypervolume]{hypervolume()}}.
}
\details{
The hypervolume contribution of point \eqn{\vec{p} \in X} is defined as
\eqn{\text{hvc}(\vec{p}) = \text{hyp}(X) - \text{hyp}(X \setminus
\{\vec{p}\})}.  This definition implies that duplicated points have zero
contribution even if not dominated, because removing one of the duplicates
does not change the hypervolume of the remaining set.  Moreover, dominated
points also have zero contribution. However, a point that is dominated by a
single (dominating) nondominated point reduces the contribution of the
latter, because removing the dominating point makes the dominated one become
nondominated.

Handling this special case is non-trivial and makes the computation more
expensive, thus the default (\code{ignore_dominated=TRUE}) ignores all dominated
points in the input, that is, their contribution is set to zero and their
presence does not affect the contribution of any other point.  Setting
\code{ignore_dominated=FALSE} will consider dominated points according to the
mathematical definition given above, but the computation will be slower.

When the input only consists of mutually nondominated points, the value of
\code{ignore_dominated} does not change the result, but the default value is
significantly faster.

The current implementation uses a \eqn{O(n\log n)} dimension-sweep
algorithm for 2D.  With \code{ignore_dominated=TRUE}, the 3D case uses the HVC3D
algorithm \citep{GueFon2017hv4d}, which has \eqn{O(n\log n)} complexity.
Otherwise, the implementation uses the naive algorithm that requires
calculating the hypervolume \eqn{|X|+1} times.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=hypervolume]{hypervolume()}}
}
\author{
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
}
\concept{metrics}
\examples{
x <- matrix(c(5,1, 1,5, 4,2, 4,4, 5,1), ncol=2, byrow=TRUE)
hv_contributions(x, reference=c(6,6))
# hvc[(5,1)] = 0 = duplicated
# hvc[(1,5)] = 3 = (4 - 1) * (6 - 5)
# hvc[(4,2)] = 3 = (5 - 4) * (5 - 2)
# hvc[(4,4)] = 0 = dominated
# hvc[(5,1)] = 0 = duplicated
hv_contributions(x, reference=c(6,6), ignore_dominated = FALSE)
# hvc[(5,1)] = 0 = duplicated
# hvc[(1,5)] = 3 = (4 - 1) * (6 - 5)
# hvc[(4,2)] = 2 = (5 - 4) * (4 - 2)
# hvc[(4,4)] = 0 = dominated
# hvc[(5,1)] = 0 = duplicated
data(SPEA2minstoptimeRichmond)
# The second objective must be maximized
# We calculate the hypervolume contribution of each point of the union of all sets.
hv_contributions(SPEA2minstoptimeRichmond[, 1:2], reference = c(250, 0),
            maximise = c(FALSE, TRUE))

# Duplicated points show zero contribution above, even if not
# dominated. However, filter_dominated removes all duplicates except
# one. Hence, there are more points below with nonzero contribution.
hv_contributions(filter_dominated(SPEA2minstoptimeRichmond[, 1:2], maximise = c(FALSE, TRUE)),
                 reference = c(250, 0), maximise = c(FALSE, TRUE))
}
