% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mylatex.R
\name{mylatex}
\alias{mylatex}
\alias{mylatex.default}
\alias{mylatex.mytable}
\alias{mylatex.cbind.mytable}
\title{Exporting "cbind.mytable","mytable" to LaTeX format}
\usage{
mylatex(myobj, size = 5, caption = NULL, caption.placement = "top",
  caption.position = "c")

\method{mylatex}{default}(myobj, size = 5, caption = NULL,
  caption.placement = "top", caption.position = "c")

\method{mylatex}{mytable}(myobj, size = 5, caption = NULL,
  caption.placement = "top", caption.position = "c")

\method{mylatex}{cbind.mytable}(myobj, size = 5, caption = NULL,
  caption.placement = "top", caption.position = "c")
}
\arguments{
\item{myobj}{An object of class 'mytable'}

\item{size}{An integer indicating font size, defaulting is 5.}

\item{caption}{A character}

\item{caption.placement}{The caption will be have placed at the top of the table
if caption.placement is "top" and at the bottom of the table
if it equals "bottom". Default value is "top".}

\item{caption.position}{The caption will be have placed at the center of the table
if caption.position is "center" or "c", and at the left side of the table
if it equals "left" or "l", and at the right side of the table
if it equals "right" or "r". Default value is "center".}
}
\description{
Exporting "cbind.mytable","mytable" to LaTeX format
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Exporting "cbind.mytable","mytable" to LaTeX format

\item \code{mytable}: Exporting "cbind.mytable","mytable" to LaTeX format

\item \code{cbind.mytable}: Exporting "cbind.mytable","mytable" to LaTeX format
}}

\examples{
require(moonBook)
out=mytable(sex~.,data=acs)
mylatex(out)
out1=mytable(sex+Dx~.,data=acs)
mylatex(out1,size=6)
}
